@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property aggregationConfig Aggregation settings that you can use to customize the output format of your flow data. See Aggregation Config for more details.
 * @property fileType File type that Amazon AppFlow places in the Amazon S3 bucket. Valid values are `CSV`, `JSON`, and `PARQUET`.
 * @property prefixConfig Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date. See Prefix Config for more details.
 * @property preserveSourceDataTyping Whether the data types from the source system need to be preserved (Only valid for `Parquet` file type)
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfig(
    public val aggregationConfig: FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfig? =
        null,
    public val fileType: String? = null,
    public val prefixConfig: FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigPrefixConfig? =
        null,
    public val preserveSourceDataTyping: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfig): FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfig =
            FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfig(
                aggregationConfig = javaType.aggregationConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                fileType = javaType.fileType().map({ args0 -> args0 }).orElse(null),
                prefixConfig = javaType.prefixConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigPrefixConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                preserveSourceDataTyping = javaType.preserveSourceDataTyping().map({ args0 -> args0 }).orElse(null),
            )
    }
}
