@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property aggregationType Whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated. Valid values are `None` and `SingleFile`.
 * @property targetFileSize The desired file size, in MB, for each output file that Amazon AppFlow writes to the flow destination. Integer value.
 */
public data class
FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfig(
    public val aggregationType: String? = null,
    public val targetFileSize: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfig): FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfig =
            FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfig(
                aggregationType = javaType.aggregationType().map({ args0 -> args0 }).orElse(null),
                targetFileSize = javaType.targetFileSize().map({ args0 -> args0 }).orElse(null),
            )
    }
}
