@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property errorHandlingConfig
 * @property idFieldNames
 * @property objectPath
 * @property successResponseHandlingConfig Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data. See Success Response Handling Config for more details.
 * @property writeOperationType
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesSapoData(
    public val errorHandlingConfig: FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataErrorHandlingConfig? = null,
    public val idFieldNames: List<String>? = null,
    public val objectPath: String,
    public val successResponseHandlingConfig: FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfig? =
        null,
    public val writeOperationType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSapoData): FlowDestinationFlowConfigDestinationConnectorPropertiesSapoData =
            FlowDestinationFlowConfigDestinationConnectorPropertiesSapoData(
                errorHandlingConfig = javaType.errorHandlingConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataErrorHandlingConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                idFieldNames = javaType.idFieldNames().map({ args0 -> args0 }),
                objectPath = javaType.objectPath(),
                successResponseHandlingConfig = javaType.successResponseHandlingConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                writeOperationType = javaType.writeOperationType().map({ args0 -> args0 }).orElse(null),
            )
    }
}
