@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property aggregationConfig Aggregation settings that you can use to customize the output format of your flow data. See Aggregation Config for more details.
 * @property fileType File type that Amazon AppFlow places in the Amazon S3 bucket. Valid values are `CSV`, `JSON`, and `PARQUET`.
 * @property prefixConfig Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date. See Prefix Config for more details.
 */
public data class
FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfig(
    public val aggregationConfig: FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigAggregationConfig? =
        null,
    public val fileType: String? = null,
    public val prefixConfig: FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfig,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfig): FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfig =
            FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfig(
                aggregationConfig = javaType.aggregationConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigAggregationConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                fileType = javaType.fileType().map({ args0 -> args0 }).orElse(null),
                prefixConfig = javaType.prefixConfig().let({ args0 ->
                    com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfig.Companion.toKotlin(args0)
                }),
            )
    }
}
