@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property databaseName The name of an existing Glue database to store the metadata tables that Amazon AppFlow creates.
 * @property roleArn The ARN of an IAM role that grants AppFlow the permissions it needs to create Data Catalog tables, databases, and partitions.
 * @property tablePrefix A naming prefix for each Data Catalog table that Amazon AppFlow creates
 */
public data class FlowMetadataCatalogConfigGlueDataCatalog(
    public val databaseName: String,
    public val roleArn: String,
    public val tablePrefix: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowMetadataCatalogConfigGlueDataCatalog): FlowMetadataCatalogConfigGlueDataCatalog = FlowMetadataCatalogConfigGlueDataCatalog(
            databaseName = javaType.databaseName(),
            roleArn = javaType.roleArn(),
            tablePrefix = javaType.tablePrefix(),
        )
    }
}
