@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property apiVersion API version that the destination connector uses.
 * @property connectorProfileName Name of the connector profile. This name must be unique for each connector profile in the AWS account.
 * @property connectorType Type of connector, such as Salesforce, Amplitude, and so on. Valid values are `Salesforce`, `Singular`, `Slack`, `Redshift`, `S3`, `Marketo`, `Googleanalytics`, `Zendesk`, `Servicenow`, `Datadog`, `Trendmicro`, `Snowflake`, `Dynatrace`, `Infornexus`, `Amplitude`, `Veeva`, `EventBridge`, `LookoutMetrics`, `Upsolver`, `Honeycode`, `CustomerProfiles`, `SAPOData`, and `CustomConnector`.
 * @property incrementalPullConfig Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull. See Incremental Pull Config for more details.
 * @property sourceConnectorProperties Information that is required to query a particular source connector. See Source Connector Properties for details.
 */
public data class FlowSourceFlowConfig(
    public val apiVersion: String? = null,
    public val connectorProfileName: String? = null,
    public val connectorType: String,
    public val incrementalPullConfig: FlowSourceFlowConfigIncrementalPullConfig? = null,
    public val sourceConnectorProperties: FlowSourceFlowConfigSourceConnectorProperties,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowSourceFlowConfig): FlowSourceFlowConfig = FlowSourceFlowConfig(
            apiVersion = javaType.apiVersion().map({ args0 -> args0 }).orElse(null),
            connectorProfileName = javaType.connectorProfileName().map({ args0 -> args0 }).orElse(null),
            connectorType = javaType.connectorType(),
            incrementalPullConfig = javaType.incrementalPullConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigIncrementalPullConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sourceConnectorProperties = javaType.sourceConnectorProperties().let({ args0 ->
                com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorProperties.Companion.toKotlin(args0)
            }),
        )
    }
}
