@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property amplitude Information that is required for querying Amplitude. See Generic Source Properties for more details.
 * @property customConnector Properties that are applied when the custom connector is being used as a source. See Custom Connector Source Properties.
 * @property datadog Information that is required for querying Datadog. See Generic Source Properties for more details.
 * @property dynatrace Operation to be performed on the provided Dynatrace source fields. Valid values are `PROJECTION`, `BETWEEN`, `EQUAL_TO`, `ADDITION`, `MULTIPLICATION`, `DIVISION`, `SUBTRACTION`, `MASK_ALL`, `MASK_FIRST_N`, `MASK_LAST_N`, `VALIDATE_NON_NULL`, `VALIDATE_NON_ZERO`, `VALIDATE_NON_NEGATIVE`, `VALIDATE_NUMERIC`, and `NO_OP`.
 * @property googleAnalytics Operation to be performed on the provided Google Analytics source fields. Valid values are `PROJECTION` and `BETWEEN`.
 * @property inforNexus Information that is required for querying Infor Nexus. See Generic Source Properties for more details.
 * @property marketo Information that is required for querying Marketo. See Generic Source Properties for more details.
 * @property s3 Information that is required for querying Amazon S3. See S3 Source Properties for more details.
 * @property salesforce Information that is required for querying Salesforce. See Salesforce Source Properties for more details.
 * @property sapoData Information that is required for querying SAPOData as a flow source. See SAPO Source Properties for more details.
 * @property serviceNow Information that is required for querying ServiceNow. See Generic Source Properties for more details.
 * @property singular Information that is required for querying Singular. See Generic Source Properties for more details.
 * @property slack Information that is required for querying Slack. See Generic Source Properties for more details.
 * @property trendmicro Operation to be performed on the provided Trend Micro source fields. Valid values are `PROJECTION`, `EQUAL_TO`, `ADDITION`, `MULTIPLICATION`, `DIVISION`, `SUBTRACTION`, `MASK_ALL`, `MASK_FIRST_N`, `MASK_LAST_N`, `VALIDATE_NON_NULL`, `VALIDATE_NON_ZERO`, `VALIDATE_NON_NEGATIVE`, `VALIDATE_NUMERIC`, and `NO_OP`.
 * @property veeva Information that is required for querying Veeva. See Veeva Source Properties for more details.
 * @property zendesk Information that is required for querying Zendesk. See Generic Source Properties for more details.
 */
public data class FlowSourceFlowConfigSourceConnectorProperties(
    public val amplitude: FlowSourceFlowConfigSourceConnectorPropertiesAmplitude? = null,
    public val customConnector: FlowSourceFlowConfigSourceConnectorPropertiesCustomConnector? = null,
    public val datadog: FlowSourceFlowConfigSourceConnectorPropertiesDatadog? = null,
    public val dynatrace: FlowSourceFlowConfigSourceConnectorPropertiesDynatrace? = null,
    public val googleAnalytics: FlowSourceFlowConfigSourceConnectorPropertiesGoogleAnalytics? = null,
    public val inforNexus: FlowSourceFlowConfigSourceConnectorPropertiesInforNexus? = null,
    public val marketo: FlowSourceFlowConfigSourceConnectorPropertiesMarketo? = null,
    public val s3: FlowSourceFlowConfigSourceConnectorPropertiesS3? = null,
    public val salesforce: FlowSourceFlowConfigSourceConnectorPropertiesSalesforce? = null,
    public val sapoData: FlowSourceFlowConfigSourceConnectorPropertiesSapoData? = null,
    public val serviceNow: FlowSourceFlowConfigSourceConnectorPropertiesServiceNow? = null,
    public val singular: FlowSourceFlowConfigSourceConnectorPropertiesSingular? = null,
    public val slack: FlowSourceFlowConfigSourceConnectorPropertiesSlack? = null,
    public val trendmicro: FlowSourceFlowConfigSourceConnectorPropertiesTrendmicro? = null,
    public val veeva: FlowSourceFlowConfigSourceConnectorPropertiesVeeva? = null,
    public val zendesk: FlowSourceFlowConfigSourceConnectorPropertiesZendesk? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowSourceFlowConfigSourceConnectorProperties): FlowSourceFlowConfigSourceConnectorProperties =
            FlowSourceFlowConfigSourceConnectorProperties(
                amplitude = javaType.amplitude().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesAmplitude.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                customConnector = javaType.customConnector().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesCustomConnector.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                datadog = javaType.datadog().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesDatadog.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                dynatrace = javaType.dynatrace().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesDynatrace.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                googleAnalytics = javaType.googleAnalytics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesGoogleAnalytics.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                inforNexus = javaType.inforNexus().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesInforNexus.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                marketo = javaType.marketo().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesMarketo.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                s3 = javaType.s3().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesS3.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                salesforce = javaType.salesforce().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesSalesforce.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sapoData = javaType.sapoData().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesSapoData.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                serviceNow = javaType.serviceNow().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesServiceNow.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                singular = javaType.singular().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesSingular.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                slack = javaType.slack().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesSlack.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                trendmicro = javaType.trendmicro().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesTrendmicro.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                veeva = javaType.veeva().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesVeeva.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                zendesk = javaType.zendesk().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesZendesk.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
