@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName
 * @property bucketPrefix
 * @property s3InputFormatConfig When you use Amazon S3 as the source, the configuration format that you provide the flow input data. See S3 Input Format Config for details.
 */
public data class FlowSourceFlowConfigSourceConnectorPropertiesS3(
    public val bucketName: String,
    public val bucketPrefix: String,
    public val s3InputFormatConfig: FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfig? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowSourceFlowConfigSourceConnectorPropertiesS3): FlowSourceFlowConfigSourceConnectorPropertiesS3 =
            FlowSourceFlowConfigSourceConnectorPropertiesS3(
                bucketName = javaType.bucketName(),
                bucketPrefix = javaType.bucketPrefix(),
                s3InputFormatConfig = javaType.s3InputFormatConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
