@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataPullMode Whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run. Valid values are `Incremental` and `Complete`.
 * @property firstExecutionFrom Date range for the records to import from the connector in the first flow run. Must be a valid RFC3339 timestamp.
 * @property scheduleEndTime Scheduled end time for a schedule-triggered flow. Must be a valid RFC3339 timestamp.
 * @property scheduleExpression Scheduling expression that determines the rate at which the schedule will run, for example `rate(5minutes)`.
 * @property scheduleOffset Optional offset that is added to the time interval for a schedule-triggered flow. Maximum value of 36000.
 * @property scheduleStartTime Scheduled start time for a schedule-triggered flow. Must be a valid RFC3339 timestamp.
 * @property timezone Time zone used when referring to the date and time of a scheduled-triggered flow, such as `America/New_York`.
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appflow.Flow;
 * import com.pulumi.aws.appflow.FlowArgs;
 * import com.pulumi.aws.appflow.inputs.FlowTriggerConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Flow("example", FlowArgs.builder()
 *             .triggerConfig(FlowTriggerConfigArgs.builder()
 *                 .scheduled(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appflow:Flow
 *     properties:
 *       triggerConfig:
 *         scheduled:
 *           - scheduleExpression: rate(1minutes)
 * ```
 * <!--End PulumiCodeChooser -->
 */
public data class FlowTriggerConfigTriggerPropertiesScheduled(
    public val dataPullMode: String? = null,
    public val firstExecutionFrom: String? = null,
    public val scheduleEndTime: String? = null,
    public val scheduleExpression: String,
    public val scheduleOffset: Int? = null,
    public val scheduleStartTime: String? = null,
    public val timezone: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowTriggerConfigTriggerPropertiesScheduled): FlowTriggerConfigTriggerPropertiesScheduled = FlowTriggerConfigTriggerPropertiesScheduled(
            dataPullMode = javaType.dataPullMode().map({ args0 -> args0 }).orElse(null),
            firstExecutionFrom = javaType.firstExecutionFrom().map({ args0 -> args0 }).orElse(null),
            scheduleEndTime = javaType.scheduleEndTime().map({ args0 -> args0 }).orElse(null),
            scheduleExpression = javaType.scheduleExpression(),
            scheduleOffset = javaType.scheduleOffset().map({ args0 -> args0 }).orElse(null),
            scheduleStartTime = javaType.scheduleStartTime().map({ args0 -> args0 }).orElse(null),
            timezone = javaType.timezone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
