@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appintegrations.kotlin

import com.pulumi.aws.appintegrations.DataIntegrationArgs.builder
import com.pulumi.aws.appintegrations.kotlin.inputs.DataIntegrationScheduleConfigArgs
import com.pulumi.aws.appintegrations.kotlin.inputs.DataIntegrationScheduleConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon AppIntegrations Data Integration resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appintegrations.DataIntegration("example", {
 *     name: "example",
 *     description: "example",
 *     kmsKey: test.arn,
 *     sourceUri: "Salesforce://AppFlow/example",
 *     scheduleConfig: {
 *         firstExecutionFrom: "1439788442681",
 *         object: "Account",
 *         scheduleExpression: "rate(1 hour)",
 *     },
 *     tags: {
 *         Key1: "Value1",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appintegrations.DataIntegration("example",
 *     name="example",
 *     description="example",
 *     kms_key=test["arn"],
 *     source_uri="Salesforce://AppFlow/example",
 *     schedule_config={
 *         "first_execution_from": "1439788442681",
 *         "object": "Account",
 *         "schedule_expression": "rate(1 hour)",
 *     },
 *     tags={
 *         "Key1": "Value1",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppIntegrations.DataIntegration("example", new()
 *     {
 *         Name = "example",
 *         Description = "example",
 *         KmsKey = test.Arn,
 *         SourceUri = "Salesforce://AppFlow/example",
 *         ScheduleConfig = new Aws.AppIntegrations.Inputs.DataIntegrationScheduleConfigArgs
 *         {
 *             FirstExecutionFrom = "1439788442681",
 *             Object = "Account",
 *             ScheduleExpression = "rate(1 hour)",
 *         },
 *         Tags =
 *         {
 *             { "Key1", "Value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appintegrations"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appintegrations.NewDataIntegration(ctx, "example", &appintegrations.DataIntegrationArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("example"),
 * 			KmsKey:      pulumi.Any(test.Arn),
 * 			SourceUri:   pulumi.String("Salesforce://AppFlow/example"),
 * 			ScheduleConfig: &appintegrations.DataIntegrationScheduleConfigArgs{
 * 				FirstExecutionFrom: pulumi.String("1439788442681"),
 * 				Object:             pulumi.String("Account"),
 * 				ScheduleExpression: pulumi.String("rate(1 hour)"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Key1": pulumi.String("Value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appintegrations.DataIntegration;
 * import com.pulumi.aws.appintegrations.DataIntegrationArgs;
 * import com.pulumi.aws.appintegrations.inputs.DataIntegrationScheduleConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataIntegration("example", DataIntegrationArgs.builder()
 *             .name("example")
 *             .description("example")
 *             .kmsKey(test.arn())
 *             .sourceUri("Salesforce://AppFlow/example")
 *             .scheduleConfig(DataIntegrationScheduleConfigArgs.builder()
 *                 .firstExecutionFrom("1439788442681")
 *                 .object("Account")
 *                 .scheduleExpression("rate(1 hour)")
 *                 .build())
 *             .tags(Map.of("Key1", "Value1"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appintegrations:DataIntegration
 *     properties:
 *       name: example
 *       description: example
 *       kmsKey: ${test.arn}
 *       sourceUri: Salesforce://AppFlow/example
 *       scheduleConfig:
 *         firstExecutionFrom: '1439788442681'
 *         object: Account
 *         scheduleExpression: rate(1 hour)
 *       tags:
 *         Key1: Value1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon AppIntegrations Data Integrations using the `id`. For example:
 * ```sh
 * $ pulumi import aws:appintegrations/dataIntegration:DataIntegration example 12345678-1234-1234-1234-123456789123
 * ```
 * @property description Specifies the description of the Data Integration.
 * @property kmsKey Specifies the KMS key Amazon Resource Name (ARN) for the Data Integration.
 * @property name Specifies the name of the Data Integration.
 * @property scheduleConfig A block that defines the name of the data and how often it should be pulled from the source. The Schedule Config block is documented below.
 * @property sourceUri Specifies the URI of the data source. Create an AppFlow Connector Profile and reference the name of the profile in the URL. An example of this value for Salesforce is `Salesforce://AppFlow/example` where `example` is the name of the AppFlow Connector Profile.
 * @property tags Tags to apply to the Data Integration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DataIntegrationArgs(
    public val description: Output<String>? = null,
    public val kmsKey: Output<String>? = null,
    public val name: Output<String>? = null,
    public val scheduleConfig: Output<DataIntegrationScheduleConfigArgs>? = null,
    public val sourceUri: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appintegrations.DataIntegrationArgs> {
    override fun toJava(): com.pulumi.aws.appintegrations.DataIntegrationArgs =
        com.pulumi.aws.appintegrations.DataIntegrationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .kmsKey(kmsKey?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .scheduleConfig(scheduleConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceUri(sourceUri?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DataIntegrationArgs].
 */
@PulumiTagMarker
public class DataIntegrationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var kmsKey: Output<String>? = null

    private var name: Output<String>? = null

    private var scheduleConfig: Output<DataIntegrationScheduleConfigArgs>? = null

    private var sourceUri: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the description of the Data Integration.
     */
    @JvmName("qrotgimdqvmpedje")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies the KMS key Amazon Resource Name (ARN) for the Data Integration.
     */
    @JvmName("fylwfoplbimvxttt")
    public suspend fun kmsKey(`value`: Output<String>) {
        this.kmsKey = value
    }

    /**
     * @param value Specifies the name of the Data Integration.
     */
    @JvmName("xbpjejfwxxvmdlvm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A block that defines the name of the data and how often it should be pulled from the source. The Schedule Config block is documented below.
     */
    @JvmName("vkeosrlnrogdcfkk")
    public suspend fun scheduleConfig(`value`: Output<DataIntegrationScheduleConfigArgs>) {
        this.scheduleConfig = value
    }

    /**
     * @param value Specifies the URI of the data source. Create an AppFlow Connector Profile and reference the name of the profile in the URL. An example of this value for Salesforce is `Salesforce://AppFlow/example` where `example` is the name of the AppFlow Connector Profile.
     */
    @JvmName("ssposrmbirbugsbe")
    public suspend fun sourceUri(`value`: Output<String>) {
        this.sourceUri = value
    }

    /**
     * @param value Tags to apply to the Data Integration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("almjapemykmeerpx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the description of the Data Integration.
     */
    @JvmName("stchhxgiwmwcmvtp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies the KMS key Amazon Resource Name (ARN) for the Data Integration.
     */
    @JvmName("abarniuswcbxfogp")
    public suspend fun kmsKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKey = mapped
    }

    /**
     * @param value Specifies the name of the Data Integration.
     */
    @JvmName("lhhkbwvmjdgwatgt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A block that defines the name of the data and how often it should be pulled from the source. The Schedule Config block is documented below.
     */
    @JvmName("ahxrkabqabuaslkr")
    public suspend fun scheduleConfig(`value`: DataIntegrationScheduleConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleConfig = mapped
    }

    /**
     * @param argument A block that defines the name of the data and how often it should be pulled from the source. The Schedule Config block is documented below.
     */
    @JvmName("rtyyajnndyjdtyhr")
    public suspend fun scheduleConfig(argument: suspend DataIntegrationScheduleConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataIntegrationScheduleConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scheduleConfig = mapped
    }

    /**
     * @param value Specifies the URI of the data source. Create an AppFlow Connector Profile and reference the name of the profile in the URL. An example of this value for Salesforce is `Salesforce://AppFlow/example` where `example` is the name of the AppFlow Connector Profile.
     */
    @JvmName("xspcaugjhnaplwxj")
    public suspend fun sourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceUri = mapped
    }

    /**
     * @param value Tags to apply to the Data Integration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("einmtvrwxfwlxpes")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the Data Integration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mmewbbmluhrpfmua")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DataIntegrationArgs = DataIntegrationArgs(
        description = description,
        kmsKey = kmsKey,
        name = name,
        scheduleConfig = scheduleConfig,
        sourceUri = sourceUri,
        tags = tags,
    )
}
