@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appintegrations.kotlin.inputs

import com.pulumi.aws.appintegrations.inputs.DataIntegrationScheduleConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property firstExecutionFrom The start date for objects to import in the first flow run as an Unix/epoch timestamp in milliseconds or in ISO-8601 format. This needs to be a time in the past, meaning that the data created or updated before this given date will not be downloaded.
 * @property object The name of the object to pull from the data source. Examples of objects in Salesforce include `Case`, `Account`, or `Lead`.
 * @property scheduleExpression How often the data should be pulled from data source. Examples include `rate(1 hour)`, `rate(3 hours)`, `rate(1 day)`.
 */
public data class DataIntegrationScheduleConfigArgs(
    public val firstExecutionFrom: Output<String>,
    public val `object`: Output<String>,
    public val scheduleExpression: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appintegrations.inputs.DataIntegrationScheduleConfigArgs> {
    override fun toJava(): com.pulumi.aws.appintegrations.inputs.DataIntegrationScheduleConfigArgs =
        com.pulumi.aws.appintegrations.inputs.DataIntegrationScheduleConfigArgs.builder()
            .firstExecutionFrom(firstExecutionFrom.applyValue({ args0 -> args0 }))
            .`object`(`object`.applyValue({ args0 -> args0 }))
            .scheduleExpression(scheduleExpression.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataIntegrationScheduleConfigArgs].
 */
@PulumiTagMarker
public class DataIntegrationScheduleConfigArgsBuilder internal constructor() {
    private var firstExecutionFrom: Output<String>? = null

    private var `object`: Output<String>? = null

    private var scheduleExpression: Output<String>? = null

    /**
     * @param value The start date for objects to import in the first flow run as an Unix/epoch timestamp in milliseconds or in ISO-8601 format. This needs to be a time in the past, meaning that the data created or updated before this given date will not be downloaded.
     */
    @JvmName("rxnwwgygsyrtxwqw")
    public suspend fun firstExecutionFrom(`value`: Output<String>) {
        this.firstExecutionFrom = value
    }

    /**
     * @param value The name of the object to pull from the data source. Examples of objects in Salesforce include `Case`, `Account`, or `Lead`.
     */
    @JvmName("anpcbarbdcgqacju")
    public suspend fun `object`(`value`: Output<String>) {
        this.`object` = value
    }

    /**
     * @param value How often the data should be pulled from data source. Examples include `rate(1 hour)`, `rate(3 hours)`, `rate(1 day)`.
     */
    @JvmName("oavnfwxlkaqeptrx")
    public suspend fun scheduleExpression(`value`: Output<String>) {
        this.scheduleExpression = value
    }

    /**
     * @param value The start date for objects to import in the first flow run as an Unix/epoch timestamp in milliseconds or in ISO-8601 format. This needs to be a time in the past, meaning that the data created or updated before this given date will not be downloaded.
     */
    @JvmName("yxbfsytonspyrtyu")
    public suspend fun firstExecutionFrom(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firstExecutionFrom = mapped
    }

    /**
     * @param value The name of the object to pull from the data source. Examples of objects in Salesforce include `Case`, `Account`, or `Lead`.
     */
    @JvmName("dnbyhsleoqarffve")
    public suspend fun `object`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`object` = mapped
    }

    /**
     * @param value How often the data should be pulled from data source. Examples include `rate(1 hour)`, `rate(3 hours)`, `rate(1 day)`.
     */
    @JvmName("muelphmxnrjnttee")
    public suspend fun scheduleExpression(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleExpression = mapped
    }

    internal fun build(): DataIntegrationScheduleConfigArgs = DataIntegrationScheduleConfigArgs(
        firstExecutionFrom = firstExecutionFrom ?: throw PulumiNullFieldException("firstExecutionFrom"),
        `object` = `object` ?: throw PulumiNullFieldException("object"),
        scheduleExpression = scheduleExpression ?: throw PulumiNullFieldException("scheduleExpression"),
    )
}
