@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.applicationinsights.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Application].
 */
@PulumiTagMarker
public class ApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationArgs = ApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationArgsBuilder.() -> Unit) {
        val builder = ApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Application {
        val builtJavaResource = com.pulumi.aws.applicationinsights.Application(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Application(builtJavaResource)
    }
}

/**
 * Provides a ApplicationInsights Application resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleGroup = new aws.resourcegroups.Group("example", {
 *     name: "example",
 *     resourceQuery: {
 *         query: JSON.stringify({
 *             ResourceTypeFilters: ["AWS::EC2::Instance"],
 *             TagFilters: [{
 *                 Key: "Stage",
 *                 Values: ["Test"],
 *             }],
 *         }),
 *     },
 * });
 * const example = new aws.applicationinsights.Application("example", {resourceGroupName: exampleGroup.name});
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example_group = aws.resourcegroups.Group("example",
 *     name="example",
 *     resource_query={
 *         "query": json.dumps({
 *             "resource_type_filters": ["AWS::EC2::Instance"],
 *             "tag_filters": [{
 *                 "key": "Stage",
 *                 "values": ["Test"],
 *             }],
 *         }),
 *     })
 * example = aws.applicationinsights.Application("example", resource_group_name=example_group.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleGroup = new Aws.ResourceGroups.Group("example", new()
 *     {
 *         Name = "example",
 *         ResourceQuery = new Aws.ResourceGroups.Inputs.GroupResourceQueryArgs
 *         {
 *             Query = JsonSerializer.Serialize(new Dictionary<string, object?>
 *             {
 *                 ["ResourceTypeFilters"] = new[]
 *                 {
 *                     "AWS::EC2::Instance",
 *                 },
 *                 ["TagFilters"] = new[]
 *                 {
 *                     new Dictionary<string, object?>
 *                     {
 *                         ["Key"] = "Stage",
 *                         ["Values"] = new[]
 *                         {
 *                             "Test",
 *                         },
 *                     },
 *                 },
 *             }),
 *         },
 *     });
 *     var example = new Aws.ApplicationInsights.Application("example", new()
 *     {
 *         ResourceGroupName = exampleGroup.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/applicationinsights"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/resourcegroups"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"ResourceTypeFilters": []string{
 * 				"AWS::EC2::Instance",
 * 			},
 * 			"TagFilters": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Key": "Stage",
 * 					"Values": []string{
 * 						"Test",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		exampleGroup, err := resourcegroups.NewGroup(ctx, "example", &resourcegroups.GroupArgs{
 * 			Name: pulumi.String("example"),
 * 			ResourceQuery: &resourcegroups.GroupResourceQueryArgs{
 * 				Query: pulumi.String(json0),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = applicationinsights.NewApplication(ctx, "example", &applicationinsights.ApplicationArgs{
 * 			ResourceGroupName: exampleGroup.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.resourcegroups.Group;
 * import com.pulumi.aws.resourcegroups.GroupArgs;
 * import com.pulumi.aws.resourcegroups.inputs.GroupResourceQueryArgs;
 * import com.pulumi.aws.applicationinsights.Application;
 * import com.pulumi.aws.applicationinsights.ApplicationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .name("example")
 *             .resourceQuery(GroupResourceQueryArgs.builder()
 *                 .query(serializeJson(
 *                     jsonObject(
 *                         jsonProperty("ResourceTypeFilters", jsonArray("AWS::EC2::Instance")),
 *                         jsonProperty("TagFilters", jsonArray(jsonObject(
 *                             jsonProperty("Key", "Stage"),
 *                             jsonProperty("Values", jsonArray("Test"))
 *                         )))
 *                     )))
 *                 .build())
 *             .build());
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .resourceGroupName(exampleGroup.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:applicationinsights:Application
 *     properties:
 *       resourceGroupName: ${exampleGroup.name}
 *   exampleGroup:
 *     type: aws:resourcegroups:Group
 *     name: example
 *     properties:
 *       name: example
 *       resourceQuery:
 *         query:
 *           fn::toJSON:
 *             ResourceTypeFilters:
 *               - AWS::EC2::Instance
 *             TagFilters:
 *               - Key: Stage
 *                 Values:
 *                   - Test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ApplicationInsights Applications using the `resource_group_name`. For example:
 * ```sh
 * $ pulumi import aws:applicationinsights/application:Application some some-application
 * ```
 */
public class Application internal constructor(
    override val javaResource: com.pulumi.aws.applicationinsights.Application,
) : KotlinCustomResource(javaResource, ApplicationMapper) {
    /**
     * ARN of the Application.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Indicates whether Application Insights automatically configures unmonitored resources in the resource group.
     */
    public val autoConfigEnabled: Output<Boolean>?
        get() = javaResource.autoConfigEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configures all of the resources in the resource group by applying the recommended configurations.
     */
    public val autoCreate: Output<Boolean>?
        get() = javaResource.autoCreate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
     */
    public val cweMonitorEnabled: Output<Boolean>?
        get() = javaResource.cweMonitorEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Application Insights can create applications based on a resource group or on an account. To create an account-based application using all of the resources in the account, set this parameter to `ACCOUNT_BASED`.
     */
    public val groupingType: Output<String>?
        get() = javaResource.groupingType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When set to `true`, creates opsItems for any problems detected on an application.
     */
    public val opsCenterEnabled: Output<Boolean>?
        get() = javaResource.opsCenterEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem.
     */
    public val opsItemSnsTopicArn: Output<String>?
        get() = javaResource.opsItemSnsTopicArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the resource group.
     * The following arguments are optional:
     */
    public val resourceGroupName: Output<String>
        get() = javaResource.resourceGroupName().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ApplicationMapper : ResourceMapper<Application> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.applicationinsights.Application::class == javaResource::class

    override fun map(javaResource: Resource): Application = Application(
        javaResource as
            com.pulumi.aws.applicationinsights.Application,
    )
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Application].
 */
public suspend fun application(name: String, block: suspend ApplicationResourceBuilder.() -> Unit): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 */
public fun application(name: String): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
