@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.applicationinsights.kotlin

import com.pulumi.aws.applicationinsights.ApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ApplicationInsights Application resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleGroup = new aws.resourcegroups.Group("example", {
 *     name: "example",
 *     resourceQuery: {
 *         query: JSON.stringify({
 *             ResourceTypeFilters: ["AWS::EC2::Instance"],
 *             TagFilters: [{
 *                 Key: "Stage",
 *                 Values: ["Test"],
 *             }],
 *         }),
 *     },
 * });
 * const example = new aws.applicationinsights.Application("example", {resourceGroupName: exampleGroup.name});
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example_group = aws.resourcegroups.Group("example",
 *     name="example",
 *     resource_query={
 *         "query": json.dumps({
 *             "resource_type_filters": ["AWS::EC2::Instance"],
 *             "tag_filters": [{
 *                 "key": "Stage",
 *                 "values": ["Test"],
 *             }],
 *         }),
 *     })
 * example = aws.applicationinsights.Application("example", resource_group_name=example_group.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleGroup = new Aws.ResourceGroups.Group("example", new()
 *     {
 *         Name = "example",
 *         ResourceQuery = new Aws.ResourceGroups.Inputs.GroupResourceQueryArgs
 *         {
 *             Query = JsonSerializer.Serialize(new Dictionary<string, object?>
 *             {
 *                 ["ResourceTypeFilters"] = new[]
 *                 {
 *                     "AWS::EC2::Instance",
 *                 },
 *                 ["TagFilters"] = new[]
 *                 {
 *                     new Dictionary<string, object?>
 *                     {
 *                         ["Key"] = "Stage",
 *                         ["Values"] = new[]
 *                         {
 *                             "Test",
 *                         },
 *                     },
 *                 },
 *             }),
 *         },
 *     });
 *     var example = new Aws.ApplicationInsights.Application("example", new()
 *     {
 *         ResourceGroupName = exampleGroup.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/applicationinsights"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/resourcegroups"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"ResourceTypeFilters": []string{
 * 				"AWS::EC2::Instance",
 * 			},
 * 			"TagFilters": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Key": "Stage",
 * 					"Values": []string{
 * 						"Test",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		exampleGroup, err := resourcegroups.NewGroup(ctx, "example", &resourcegroups.GroupArgs{
 * 			Name: pulumi.String("example"),
 * 			ResourceQuery: &resourcegroups.GroupResourceQueryArgs{
 * 				Query: pulumi.String(json0),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = applicationinsights.NewApplication(ctx, "example", &applicationinsights.ApplicationArgs{
 * 			ResourceGroupName: exampleGroup.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.resourcegroups.Group;
 * import com.pulumi.aws.resourcegroups.GroupArgs;
 * import com.pulumi.aws.resourcegroups.inputs.GroupResourceQueryArgs;
 * import com.pulumi.aws.applicationinsights.Application;
 * import com.pulumi.aws.applicationinsights.ApplicationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .name("example")
 *             .resourceQuery(GroupResourceQueryArgs.builder()
 *                 .query(serializeJson(
 *                     jsonObject(
 *                         jsonProperty("ResourceTypeFilters", jsonArray("AWS::EC2::Instance")),
 *                         jsonProperty("TagFilters", jsonArray(jsonObject(
 *                             jsonProperty("Key", "Stage"),
 *                             jsonProperty("Values", jsonArray("Test"))
 *                         )))
 *                     )))
 *                 .build())
 *             .build());
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .resourceGroupName(exampleGroup.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:applicationinsights:Application
 *     properties:
 *       resourceGroupName: ${exampleGroup.name}
 *   exampleGroup:
 *     type: aws:resourcegroups:Group
 *     name: example
 *     properties:
 *       name: example
 *       resourceQuery:
 *         query:
 *           fn::toJSON:
 *             ResourceTypeFilters:
 *               - AWS::EC2::Instance
 *             TagFilters:
 *               - Key: Stage
 *                 Values:
 *                   - Test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ApplicationInsights Applications using the `resource_group_name`. For example:
 * ```sh
 * $ pulumi import aws:applicationinsights/application:Application some some-application
 * ```
 * @property autoConfigEnabled Indicates whether Application Insights automatically configures unmonitored resources in the resource group.
 * @property autoCreate Configures all of the resources in the resource group by applying the recommended configurations.
 * @property cweMonitorEnabled Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
 * @property groupingType Application Insights can create applications based on a resource group or on an account. To create an account-based application using all of the resources in the account, set this parameter to `ACCOUNT_BASED`.
 * @property opsCenterEnabled When set to `true`, creates opsItems for any problems detected on an application.
 * @property opsItemSnsTopicArn SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem.
 * @property resourceGroupName Name of the resource group.
 * The following arguments are optional:
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ApplicationArgs(
    public val autoConfigEnabled: Output<Boolean>? = null,
    public val autoCreate: Output<Boolean>? = null,
    public val cweMonitorEnabled: Output<Boolean>? = null,
    public val groupingType: Output<String>? = null,
    public val opsCenterEnabled: Output<Boolean>? = null,
    public val opsItemSnsTopicArn: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.applicationinsights.ApplicationArgs> {
    override fun toJava(): com.pulumi.aws.applicationinsights.ApplicationArgs =
        com.pulumi.aws.applicationinsights.ApplicationArgs.builder()
            .autoConfigEnabled(autoConfigEnabled?.applyValue({ args0 -> args0 }))
            .autoCreate(autoCreate?.applyValue({ args0 -> args0 }))
            .cweMonitorEnabled(cweMonitorEnabled?.applyValue({ args0 -> args0 }))
            .groupingType(groupingType?.applyValue({ args0 -> args0 }))
            .opsCenterEnabled(opsCenterEnabled?.applyValue({ args0 -> args0 }))
            .opsItemSnsTopicArn(opsItemSnsTopicArn?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var autoConfigEnabled: Output<Boolean>? = null

    private var autoCreate: Output<Boolean>? = null

    private var cweMonitorEnabled: Output<Boolean>? = null

    private var groupingType: Output<String>? = null

    private var opsCenterEnabled: Output<Boolean>? = null

    private var opsItemSnsTopicArn: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Indicates whether Application Insights automatically configures unmonitored resources in the resource group.
     */
    @JvmName("gwnjybddeagieroa")
    public suspend fun autoConfigEnabled(`value`: Output<Boolean>) {
        this.autoConfigEnabled = value
    }

    /**
     * @param value Configures all of the resources in the resource group by applying the recommended configurations.
     */
    @JvmName("aowsbjbxtjioonxa")
    public suspend fun autoCreate(`value`: Output<Boolean>) {
        this.autoCreate = value
    }

    /**
     * @param value Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
     */
    @JvmName("vqwiwicuxkpuoqnc")
    public suspend fun cweMonitorEnabled(`value`: Output<Boolean>) {
        this.cweMonitorEnabled = value
    }

    /**
     * @param value Application Insights can create applications based on a resource group or on an account. To create an account-based application using all of the resources in the account, set this parameter to `ACCOUNT_BASED`.
     */
    @JvmName("iagyiwphnhkyrqmd")
    public suspend fun groupingType(`value`: Output<String>) {
        this.groupingType = value
    }

    /**
     * @param value When set to `true`, creates opsItems for any problems detected on an application.
     */
    @JvmName("vebnfswbjgpeaqtw")
    public suspend fun opsCenterEnabled(`value`: Output<Boolean>) {
        this.opsCenterEnabled = value
    }

    /**
     * @param value SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem.
     */
    @JvmName("emrhlgmqotsuvytk")
    public suspend fun opsItemSnsTopicArn(`value`: Output<String>) {
        this.opsItemSnsTopicArn = value
    }

    /**
     * @param value Name of the resource group.
     * The following arguments are optional:
     */
    @JvmName("hdgkkxcqorilwyds")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hsfhnbofaklymxaw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Indicates whether Application Insights automatically configures unmonitored resources in the resource group.
     */
    @JvmName("xnybfoiiivopputf")
    public suspend fun autoConfigEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoConfigEnabled = mapped
    }

    /**
     * @param value Configures all of the resources in the resource group by applying the recommended configurations.
     */
    @JvmName("dpdbnhqmqxldyymq")
    public suspend fun autoCreate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoCreate = mapped
    }

    /**
     * @param value Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
     */
    @JvmName("dejmgnsslbbwedas")
    public suspend fun cweMonitorEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cweMonitorEnabled = mapped
    }

    /**
     * @param value Application Insights can create applications based on a resource group or on an account. To create an account-based application using all of the resources in the account, set this parameter to `ACCOUNT_BASED`.
     */
    @JvmName("scvishfxupuxriqk")
    public suspend fun groupingType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupingType = mapped
    }

    /**
     * @param value When set to `true`, creates opsItems for any problems detected on an application.
     */
    @JvmName("gdgxuhqusepqfeni")
    public suspend fun opsCenterEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opsCenterEnabled = mapped
    }

    /**
     * @param value SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem.
     */
    @JvmName("phkuoqfxtenlmdyn")
    public suspend fun opsItemSnsTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opsItemSnsTopicArn = mapped
    }

    /**
     * @param value Name of the resource group.
     * The following arguments are optional:
     */
    @JvmName("ksisismvsvpjiqrs")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tocjegixvkyocvxp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("oebwlpmqheuwnrws")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        autoConfigEnabled = autoConfigEnabled,
        autoCreate = autoCreate,
        cweMonitorEnabled = cweMonitorEnabled,
        groupingType = groupingType,
        opsCenterEnabled = opsCenterEnabled,
        opsItemSnsTopicArn = opsItemSnsTopicArn,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
