@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin

import com.pulumi.aws.appmesh.AppmeshFunctions.getGatewayRoutePlain
import com.pulumi.aws.appmesh.AppmeshFunctions.getMeshPlain
import com.pulumi.aws.appmesh.AppmeshFunctions.getRoutePlain
import com.pulumi.aws.appmesh.AppmeshFunctions.getVirtualGatewayPlain
import com.pulumi.aws.appmesh.AppmeshFunctions.getVirtualNodePlain
import com.pulumi.aws.appmesh.AppmeshFunctions.getVirtualRouterPlain
import com.pulumi.aws.appmesh.AppmeshFunctions.getVirtualServicePlain
import com.pulumi.aws.appmesh.kotlin.inputs.GetGatewayRoutePlainArgs
import com.pulumi.aws.appmesh.kotlin.inputs.GetGatewayRoutePlainArgsBuilder
import com.pulumi.aws.appmesh.kotlin.inputs.GetMeshPlainArgs
import com.pulumi.aws.appmesh.kotlin.inputs.GetMeshPlainArgsBuilder
import com.pulumi.aws.appmesh.kotlin.inputs.GetRoutePlainArgs
import com.pulumi.aws.appmesh.kotlin.inputs.GetRoutePlainArgsBuilder
import com.pulumi.aws.appmesh.kotlin.inputs.GetVirtualGatewayPlainArgs
import com.pulumi.aws.appmesh.kotlin.inputs.GetVirtualGatewayPlainArgsBuilder
import com.pulumi.aws.appmesh.kotlin.inputs.GetVirtualNodePlainArgs
import com.pulumi.aws.appmesh.kotlin.inputs.GetVirtualNodePlainArgsBuilder
import com.pulumi.aws.appmesh.kotlin.inputs.GetVirtualRouterPlainArgs
import com.pulumi.aws.appmesh.kotlin.inputs.GetVirtualRouterPlainArgsBuilder
import com.pulumi.aws.appmesh.kotlin.inputs.GetVirtualServicePlainArgs
import com.pulumi.aws.appmesh.kotlin.inputs.GetVirtualServicePlainArgsBuilder
import com.pulumi.aws.appmesh.kotlin.outputs.GetGatewayRouteResult
import com.pulumi.aws.appmesh.kotlin.outputs.GetMeshResult
import com.pulumi.aws.appmesh.kotlin.outputs.GetRouteResult
import com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualGatewayResult
import com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeResult
import com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualRouterResult
import com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualServiceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.appmesh.kotlin.outputs.GetGatewayRouteResult.Companion.toKotlin as getGatewayRouteResultToKotlin
import com.pulumi.aws.appmesh.kotlin.outputs.GetMeshResult.Companion.toKotlin as getMeshResultToKotlin
import com.pulumi.aws.appmesh.kotlin.outputs.GetRouteResult.Companion.toKotlin as getRouteResultToKotlin
import com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualGatewayResult.Companion.toKotlin as getVirtualGatewayResultToKotlin
import com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeResult.Companion.toKotlin as getVirtualNodeResultToKotlin
import com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualRouterResult.Companion.toKotlin as getVirtualRouterResultToKotlin
import com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualServiceResult.Companion.toKotlin as getVirtualServiceResultToKotlin

public object AppmeshFunctions {
    /**
     * The App Mesh Gateway Route data source allows details of an App Mesh Gateway Route to be retrieved by its name, mesh_name, virtual_gateway_name, and optionally the mesh_owner.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.appmesh.getGatewayRoute({
     *     name: "test-route",
     *     meshName: "test-mesh",
     *     virtualGatewayName: "test-gateway",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.appmesh.get_gateway_route(name="test-route",
     *     mesh_name="test-mesh",
     *     virtual_gateway_name="test-gateway")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.AppMesh.GetGatewayRoute.Invoke(new()
     *     {
     *         Name = "test-route",
     *         MeshName = "test-mesh",
     *         VirtualGatewayName = "test-gateway",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := appmesh.LookupGatewayRoute(ctx, &appmesh.LookupGatewayRouteArgs{
     * 			Name:               "test-route",
     * 			MeshName:           "test-mesh",
     * 			VirtualGatewayName: "test-gateway",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetGatewayRouteArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = AppmeshFunctions.getGatewayRoute(GetGatewayRouteArgs.builder()
     *             .name("test-route")
     *             .meshName("test-mesh")
     *             .virtualGatewayName("test-gateway")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:appmesh:getGatewayRoute
     *       Arguments:
     *         name: test-route
     *         meshName: test-mesh
     *         virtualGatewayName: test-gateway
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGatewayRoute.
     * @return A collection of values returned by getGatewayRoute.
     */
    public suspend fun getGatewayRoute(argument: GetGatewayRoutePlainArgs): GetGatewayRouteResult =
        getGatewayRouteResultToKotlin(getGatewayRoutePlain(argument.toJava()).await())

    /**
     * @see [getGatewayRoute].
     * @param meshName Name of the service mesh in which the virtual gateway exists.
     * @param meshOwner AWS account ID of the service mesh's owner.
     * @param name Name of the gateway route.
     * @param tags Map of tags.
     * @param virtualGatewayName Name of the virtual gateway in which the route exists.
     * @return A collection of values returned by getGatewayRoute.
     */
    public suspend fun getGatewayRoute(
        meshName: String,
        meshOwner: String? = null,
        name: String,
        tags: Map<String, String>? = null,
        virtualGatewayName: String,
    ): GetGatewayRouteResult {
        val argument = GetGatewayRoutePlainArgs(
            meshName = meshName,
            meshOwner = meshOwner,
            name = name,
            tags = tags,
            virtualGatewayName = virtualGatewayName,
        )
        return getGatewayRouteResultToKotlin(getGatewayRoutePlain(argument.toJava()).await())
    }

    /**
     * @see [getGatewayRoute].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appmesh&#46;kotlin&#46;inputs&#46;GetGatewayRoutePlainArgs].
     * @return A collection of values returned by getGatewayRoute.
     */
    public suspend fun getGatewayRoute(argument: suspend GetGatewayRoutePlainArgsBuilder.() -> Unit): GetGatewayRouteResult {
        val builder = GetGatewayRoutePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewayRouteResultToKotlin(getGatewayRoutePlain(builtArgument.toJava()).await())
    }

    /**
     * The App Mesh Mesh data source allows details of an App Mesh Mesh to be retrieved by its name and optionally the mesh_owner.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const simple = aws.appmesh.getMesh({
     *     name: "simpleapp",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * simple = aws.appmesh.get_mesh(name="simpleapp")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var simple = Aws.AppMesh.GetMesh.Invoke(new()
     *     {
     *         Name = "simpleapp",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := appmesh.LookupMesh(ctx, &appmesh.LookupMeshArgs{
     * 			Name: "simpleapp",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetMeshArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var simple = AppmeshFunctions.getMesh(GetMeshArgs.builder()
     *             .name("simpleapp")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   simple:
     *     fn::invoke:
     *       Function: aws:appmesh:getMesh
     *       Arguments:
     *         name: simpleapp
     * ```
     * <!--End PulumiCodeChooser -->
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.getCallerIdentity({});
     * const simple = current.then(current => aws.appmesh.getMesh({
     *     name: "simpleapp",
     *     meshOwner: current.accountId,
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.get_caller_identity()
     * simple = aws.appmesh.get_mesh(name="simpleapp",
     *     mesh_owner=current.account_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.GetCallerIdentity.Invoke();
     *     var simple = Aws.AppMesh.GetMesh.Invoke(new()
     *     {
     *         Name = "simpleapp",
     *         MeshOwner = current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = appmesh.LookupMesh(ctx, &appmesh.LookupMeshArgs{
     * 			Name:      "simpleapp",
     * 			MeshOwner: pulumi.StringRef(current.AccountId),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetMeshArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getCallerIdentity();
     *         final var simple = AppmeshFunctions.getMesh(GetMeshArgs.builder()
     *             .name("simpleapp")
     *             .meshOwner(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:getCallerIdentity
     *       Arguments: {}
     *   simple:
     *     fn::invoke:
     *       Function: aws:appmesh:getMesh
     *       Arguments:
     *         name: simpleapp
     *         meshOwner: ${current.accountId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getMesh.
     * @return A collection of values returned by getMesh.
     */
    public suspend fun getMesh(argument: GetMeshPlainArgs): GetMeshResult =
        getMeshResultToKotlin(getMeshPlain(argument.toJava()).await())

    /**
     * @see [getMesh].
     * @param meshOwner AWS account ID of the service mesh's owner.
     * @param name Name of the service mesh.
     * @param tags Map of tags.
     * @return A collection of values returned by getMesh.
     */
    public suspend fun getMesh(
        meshOwner: String? = null,
        name: String,
        tags: Map<String, String>? = null,
    ): GetMeshResult {
        val argument = GetMeshPlainArgs(
            meshOwner = meshOwner,
            name = name,
            tags = tags,
        )
        return getMeshResultToKotlin(getMeshPlain(argument.toJava()).await())
    }

    /**
     * @see [getMesh].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appmesh&#46;kotlin&#46;inputs&#46;GetMeshPlainArgs].
     * @return A collection of values returned by getMesh.
     */
    public suspend fun getMesh(argument: suspend GetMeshPlainArgsBuilder.() -> Unit): GetMeshResult {
        val builder = GetMeshPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMeshResultToKotlin(getMeshPlain(builtArgument.toJava()).await())
    }

    /**
     * The App Mesh Route data source allows details of an App Mesh Route to be retrieved by its name, mesh_name, virtual_router_name, and optionally the mesh_owner.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetVirtualServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = AppmeshFunctions.getVirtualService(GetVirtualServiceArgs.builder()
     *             .name("test-route")
     *             .meshName("test-mesh")
     *             .virtualRouterName("test-router")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:appmesh:getVirtualService
     *       Arguments:
     *         name: test-route
     *         meshName: test-mesh
     *         virtualRouterName: test-router
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRoute.
     * @return A collection of values returned by getRoute.
     */
    public suspend fun getRoute(argument: GetRoutePlainArgs): GetRouteResult =
        getRouteResultToKotlin(getRoutePlain(argument.toJava()).await())

    /**
     * @see [getRoute].
     * @param meshName Name of the service mesh in which the virtual router exists.
     * @param meshOwner AWS account ID of the service mesh's owner.
     * @param name Name of the route.
     * @param tags Map of tags.
     * @param virtualRouterName Name of the virtual router in which the route exists.
     * @return A collection of values returned by getRoute.
     */
    public suspend fun getRoute(
        meshName: String,
        meshOwner: String? = null,
        name: String,
        tags: Map<String, String>? = null,
        virtualRouterName: String,
    ): GetRouteResult {
        val argument = GetRoutePlainArgs(
            meshName = meshName,
            meshOwner = meshOwner,
            name = name,
            tags = tags,
            virtualRouterName = virtualRouterName,
        )
        return getRouteResultToKotlin(getRoutePlain(argument.toJava()).await())
    }

    /**
     * @see [getRoute].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appmesh&#46;kotlin&#46;inputs&#46;GetRoutePlainArgs].
     * @return A collection of values returned by getRoute.
     */
    public suspend fun getRoute(argument: suspend GetRoutePlainArgsBuilder.() -> Unit): GetRouteResult {
        val builder = GetRoutePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteResultToKotlin(getRoutePlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS App Mesh Virtual Gateway.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.appmesh.getVirtualGateway({
     *     meshName: "mesh-gateway",
     *     name: "example-mesh",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.appmesh.get_virtual_gateway(mesh_name="mesh-gateway",
     *     name="example-mesh")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.AppMesh.GetVirtualGateway.Invoke(new()
     *     {
     *         MeshName = "mesh-gateway",
     *         Name = "example-mesh",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := appmesh.LookupVirtualGateway(ctx, &appmesh.LookupVirtualGatewayArgs{
     * 			MeshName: "mesh-gateway",
     * 			Name:     "example-mesh",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetVirtualGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AppmeshFunctions.getVirtualGateway(GetVirtualGatewayArgs.builder()
     *             .meshName("mesh-gateway")
     *             .name("example-mesh")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:appmesh:getVirtualGateway
     *       Arguments:
     *         meshName: mesh-gateway
     *         name: example-mesh
     * ```
     * <!--End PulumiCodeChooser -->
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetVirtualGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getCallerIdentity();
     *         final var test = AppmeshFunctions.getVirtualGateway(GetVirtualGatewayArgs.builder()
     *             .name("example.mesh.local")
     *             .meshName("example-mesh")
     *             .meshOwner(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:getCallerIdentity
     *       Arguments: {}
     *   test:
     *     fn::invoke:
     *       Function: aws:appmesh:getVirtualGateway
     *       Arguments:
     *         name: example.mesh.local
     *         meshName: example-mesh
     *         meshOwner: ${current.accountId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVirtualGateway.
     * @return A collection of values returned by getVirtualGateway.
     */
    public suspend fun getVirtualGateway(argument: GetVirtualGatewayPlainArgs): GetVirtualGatewayResult =
        getVirtualGatewayResultToKotlin(getVirtualGatewayPlain(argument.toJava()).await())

    /**
     * @see [getVirtualGateway].
     * @param meshName Name of the service mesh in which the virtual gateway exists.
     * @param name Name of the virtual gateway.
     * @param tags Map of tags.
     * @return A collection of values returned by getVirtualGateway.
     */
    public suspend fun getVirtualGateway(
        meshName: String,
        name: String,
        tags: Map<String, String>? = null,
    ): GetVirtualGatewayResult {
        val argument = GetVirtualGatewayPlainArgs(
            meshName = meshName,
            name = name,
            tags = tags,
        )
        return getVirtualGatewayResultToKotlin(getVirtualGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualGateway].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appmesh&#46;kotlin&#46;inputs&#46;GetVirtualGatewayPlainArgs].
     * @return A collection of values returned by getVirtualGateway.
     */
    public suspend fun getVirtualGateway(argument: suspend GetVirtualGatewayPlainArgsBuilder.() -> Unit): GetVirtualGatewayResult {
        val builder = GetVirtualGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualGatewayResultToKotlin(getVirtualGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS App Mesh Virtual Node.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.appmesh.getVirtualNode({
     *     name: "serviceBv1",
     *     meshName: "example-mesh",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.appmesh.get_virtual_node(name="serviceBv1",
     *     mesh_name="example-mesh")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.AppMesh.GetVirtualNode.Invoke(new()
     *     {
     *         Name = "serviceBv1",
     *         MeshName = "example-mesh",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := appmesh.LookupVirtualNode(ctx, &appmesh.LookupVirtualNodeArgs{
     * 			Name:     "serviceBv1",
     * 			MeshName: "example-mesh",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetVirtualNodeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = AppmeshFunctions.getVirtualNode(GetVirtualNodeArgs.builder()
     *             .name("serviceBv1")
     *             .meshName("example-mesh")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:appmesh:getVirtualNode
     *       Arguments:
     *         name: serviceBv1
     *         meshName: example-mesh
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVirtualNode.
     * @return A collection of values returned by getVirtualNode.
     */
    public suspend fun getVirtualNode(argument: GetVirtualNodePlainArgs): GetVirtualNodeResult =
        getVirtualNodeResultToKotlin(getVirtualNodePlain(argument.toJava()).await())

    /**
     * @see [getVirtualNode].
     * @param meshName Name of the service mesh in which the virtual node exists.
     * @param meshOwner AWS account ID of the service mesh's owner.
     * @param name Name of the virtual node.
     * @param tags Map of tags.
     * @return A collection of values returned by getVirtualNode.
     */
    public suspend fun getVirtualNode(
        meshName: String,
        meshOwner: String? = null,
        name: String,
        tags: Map<String, String>? = null,
    ): GetVirtualNodeResult {
        val argument = GetVirtualNodePlainArgs(
            meshName = meshName,
            meshOwner = meshOwner,
            name = name,
            tags = tags,
        )
        return getVirtualNodeResultToKotlin(getVirtualNodePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualNode].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appmesh&#46;kotlin&#46;inputs&#46;GetVirtualNodePlainArgs].
     * @return A collection of values returned by getVirtualNode.
     */
    public suspend fun getVirtualNode(argument: suspend GetVirtualNodePlainArgsBuilder.() -> Unit): GetVirtualNodeResult {
        val builder = GetVirtualNodePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualNodeResultToKotlin(getVirtualNodePlain(builtArgument.toJava()).await())
    }

    /**
     * The App Mesh Virtual Router data source allows details of an App Mesh Virtual Service to be retrieved by its name and mesh_name.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.appmesh.getVirtualRouter({
     *     name: "example-router-name",
     *     meshName: "example-mesh-name",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.appmesh.get_virtual_router(name="example-router-name",
     *     mesh_name="example-mesh-name")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.AppMesh.GetVirtualRouter.Invoke(new()
     *     {
     *         Name = "example-router-name",
     *         MeshName = "example-mesh-name",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := appmesh.LookupVirtualRouter(ctx, &appmesh.LookupVirtualRouterArgs{
     * 			Name:     "example-router-name",
     * 			MeshName: "example-mesh-name",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetVirtualRouterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = AppmeshFunctions.getVirtualRouter(GetVirtualRouterArgs.builder()
     *             .name("example-router-name")
     *             .meshName("example-mesh-name")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:appmesh:getVirtualRouter
     *       Arguments:
     *         name: example-router-name
     *         meshName: example-mesh-name
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVirtualRouter.
     * @return A collection of values returned by getVirtualRouter.
     */
    public suspend fun getVirtualRouter(argument: GetVirtualRouterPlainArgs): GetVirtualRouterResult =
        getVirtualRouterResultToKotlin(getVirtualRouterPlain(argument.toJava()).await())

    /**
     * @see [getVirtualRouter].
     * @param meshName Name of the mesh in which the virtual router exists
     * @param meshOwner
     * @param name Name of the virtual router.
     * @param tags Map of tags.
     * @return A collection of values returned by getVirtualRouter.
     */
    public suspend fun getVirtualRouter(
        meshName: String,
        meshOwner: String? = null,
        name: String,
        tags: Map<String, String>? = null,
    ): GetVirtualRouterResult {
        val argument = GetVirtualRouterPlainArgs(
            meshName = meshName,
            meshOwner = meshOwner,
            name = name,
            tags = tags,
        )
        return getVirtualRouterResultToKotlin(getVirtualRouterPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualRouter].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appmesh&#46;kotlin&#46;inputs&#46;GetVirtualRouterPlainArgs].
     * @return A collection of values returned by getVirtualRouter.
     */
    public suspend fun getVirtualRouter(argument: suspend GetVirtualRouterPlainArgsBuilder.() -> Unit): GetVirtualRouterResult {
        val builder = GetVirtualRouterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualRouterResultToKotlin(getVirtualRouterPlain(builtArgument.toJava()).await())
    }

    /**
     * The App Mesh Virtual Service data source allows details of an App Mesh Virtual Service to be retrieved by its name, mesh_name, and optionally the mesh_owner.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.appmesh.getVirtualService({
     *     name: "example.mesh.local",
     *     meshName: "example-mesh",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.appmesh.get_virtual_service(name="example.mesh.local",
     *     mesh_name="example-mesh")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.AppMesh.GetVirtualService.Invoke(new()
     *     {
     *         Name = "example.mesh.local",
     *         MeshName = "example-mesh",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := appmesh.LookupVirtualService(ctx, &appmesh.LookupVirtualServiceArgs{
     * 			Name:     "example.mesh.local",
     * 			MeshName: "example-mesh",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetVirtualServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = AppmeshFunctions.getVirtualService(GetVirtualServiceArgs.builder()
     *             .name("example.mesh.local")
     *             .meshName("example-mesh")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:appmesh:getVirtualService
     *       Arguments:
     *         name: example.mesh.local
     *         meshName: example-mesh
     * ```
     * <!--End PulumiCodeChooser -->
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.getCallerIdentity({});
     * const test = current.then(current => aws.appmesh.getVirtualService({
     *     name: "example.mesh.local",
     *     meshName: "example-mesh",
     *     meshOwner: current.accountId,
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.get_caller_identity()
     * test = aws.appmesh.get_virtual_service(name="example.mesh.local",
     *     mesh_name="example-mesh",
     *     mesh_owner=current.account_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.GetCallerIdentity.Invoke();
     *     var test = Aws.AppMesh.GetVirtualService.Invoke(new()
     *     {
     *         Name = "example.mesh.local",
     *         MeshName = "example-mesh",
     *         MeshOwner = current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = appmesh.LookupVirtualService(ctx, &appmesh.LookupVirtualServiceArgs{
     * 			Name:      "example.mesh.local",
     * 			MeshName:  "example-mesh",
     * 			MeshOwner: pulumi.StringRef(current.AccountId),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetVirtualServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getCallerIdentity();
     *         final var test = AppmeshFunctions.getVirtualService(GetVirtualServiceArgs.builder()
     *             .name("example.mesh.local")
     *             .meshName("example-mesh")
     *             .meshOwner(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:getCallerIdentity
     *       Arguments: {}
     *   test:
     *     fn::invoke:
     *       Function: aws:appmesh:getVirtualService
     *       Arguments:
     *         name: example.mesh.local
     *         meshName: example-mesh
     *         meshOwner: ${current.accountId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVirtualService.
     * @return A collection of values returned by getVirtualService.
     */
    public suspend fun getVirtualService(argument: GetVirtualServicePlainArgs): GetVirtualServiceResult =
        getVirtualServiceResultToKotlin(getVirtualServicePlain(argument.toJava()).await())

    /**
     * @see [getVirtualService].
     * @param meshName Name of the service mesh in which the virtual service exists.
     * @param meshOwner AWS account ID of the service mesh's owner.
     * @param name Name of the virtual service.
     * @param tags Map of tags.
     * @return A collection of values returned by getVirtualService.
     */
    public suspend fun getVirtualService(
        meshName: String,
        meshOwner: String? = null,
        name: String,
        tags: Map<String, String>? = null,
    ): GetVirtualServiceResult {
        val argument = GetVirtualServicePlainArgs(
            meshName = meshName,
            meshOwner = meshOwner,
            name = name,
            tags = tags,
        )
        return getVirtualServiceResultToKotlin(getVirtualServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualService].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appmesh&#46;kotlin&#46;inputs&#46;GetVirtualServicePlainArgs].
     * @return A collection of values returned by getVirtualService.
     */
    public suspend fun getVirtualService(argument: suspend GetVirtualServicePlainArgsBuilder.() -> Unit): GetVirtualServiceResult {
        val builder = GetVirtualServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualServiceResultToKotlin(getVirtualServicePlain(builtArgument.toJava()).await())
    }
}
