@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin

import com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpec
import com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpec.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [GatewayRoute].
 */
@PulumiTagMarker
public class GatewayRouteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayRouteArgs = GatewayRouteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayRouteArgsBuilder.() -> Unit) {
        val builder = GatewayRouteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GatewayRoute {
        val builtJavaResource = com.pulumi.aws.appmesh.GatewayRoute(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GatewayRoute(builtJavaResource)
    }
}

/**
 * Provides an AWS App Mesh gateway route resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appmesh.GatewayRoute("example", {
 *     name: "example-gateway-route",
 *     meshName: "example-service-mesh",
 *     virtualGatewayName: exampleAwsAppmeshVirtualGateway.name,
 *     spec: {
 *         httpRoute: {
 *             action: {
 *                 target: {
 *                     virtualService: {
 *                         virtualServiceName: exampleAwsAppmeshVirtualService.name,
 *                     },
 *                 },
 *             },
 *             match: {
 *                 prefix: "/",
 *             },
 *         },
 *     },
 *     tags: {
 *         Environment: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appmesh.GatewayRoute("example",
 *     name="example-gateway-route",
 *     mesh_name="example-service-mesh",
 *     virtual_gateway_name=example_aws_appmesh_virtual_gateway["name"],
 *     spec={
 *         "http_route": {
 *             "action": {
 *                 "target": {
 *                     "virtual_service": {
 *                         "virtual_service_name": example_aws_appmesh_virtual_service["name"],
 *                     },
 *                 },
 *             },
 *             "match": {
 *                 "prefix": "/",
 *             },
 *         },
 *     },
 *     tags={
 *         "Environment": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppMesh.GatewayRoute("example", new()
 *     {
 *         Name = "example-gateway-route",
 *         MeshName = "example-service-mesh",
 *         VirtualGatewayName = exampleAwsAppmeshVirtualGateway.Name,
 *         Spec = new Aws.AppMesh.Inputs.GatewayRouteSpecArgs
 *         {
 *             HttpRoute = new Aws.AppMesh.Inputs.GatewayRouteSpecHttpRouteArgs
 *             {
 *                 Action = new Aws.AppMesh.Inputs.GatewayRouteSpecHttpRouteActionArgs
 *                 {
 *                     Target = new Aws.AppMesh.Inputs.GatewayRouteSpecHttpRouteActionTargetArgs
 *                     {
 *                         VirtualService = new Aws.AppMesh.Inputs.GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs
 *                         {
 *                             VirtualServiceName = exampleAwsAppmeshVirtualService.Name,
 *                         },
 *                     },
 *                 },
 *                 Match = new Aws.AppMesh.Inputs.GatewayRouteSpecHttpRouteMatchArgs
 *                 {
 *                     Prefix = "/",
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Environment", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appmesh.NewGatewayRoute(ctx, "example", &appmesh.GatewayRouteArgs{
 * 			Name:               pulumi.String("example-gateway-route"),
 * 			MeshName:           pulumi.String("example-service-mesh"),
 * 			VirtualGatewayName: pulumi.Any(exampleAwsAppmeshVirtualGateway.Name),
 * 			Spec: &appmesh.GatewayRouteSpecArgs{
 * 				HttpRoute: &appmesh.GatewayRouteSpecHttpRouteArgs{
 * 					Action: &appmesh.GatewayRouteSpecHttpRouteActionArgs{
 * 						Target: &appmesh.GatewayRouteSpecHttpRouteActionTargetArgs{
 * 							VirtualService: &appmesh.GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs{
 * 								VirtualServiceName: pulumi.Any(exampleAwsAppmeshVirtualService.Name),
 * 							},
 * 						},
 * 					},
 * 					Match: &appmesh.GatewayRouteSpecHttpRouteMatchArgs{
 * 						Prefix: pulumi.String("/"),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.GatewayRoute;
 * import com.pulumi.aws.appmesh.GatewayRouteArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionTargetArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GatewayRoute("example", GatewayRouteArgs.builder()
 *             .name("example-gateway-route")
 *             .meshName("example-service-mesh")
 *             .virtualGatewayName(exampleAwsAppmeshVirtualGateway.name())
 *             .spec(GatewayRouteSpecArgs.builder()
 *                 .httpRoute(GatewayRouteSpecHttpRouteArgs.builder()
 *                     .action(GatewayRouteSpecHttpRouteActionArgs.builder()
 *                         .target(GatewayRouteSpecHttpRouteActionTargetArgs.builder()
 *                             .virtualService(GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs.builder()
 *                                 .virtualServiceName(exampleAwsAppmeshVirtualService.name())
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .match(GatewayRouteSpecHttpRouteMatchArgs.builder()
 *                         .prefix("/")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appmesh:GatewayRoute
 *     properties:
 *       name: example-gateway-route
 *       meshName: example-service-mesh
 *       virtualGatewayName: ${exampleAwsAppmeshVirtualGateway.name}
 *       spec:
 *         httpRoute:
 *           action:
 *             target:
 *               virtualService:
 *                 virtualServiceName: ${exampleAwsAppmeshVirtualService.name}
 *           match:
 *             prefix: /
 *       tags:
 *         Environment: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import App Mesh gateway routes using `mesh_name` and `virtual_gateway_name` together with the gateway route's `name`. For example:
 * ```sh
 * $ pulumi import aws:appmesh/gatewayRoute:GatewayRoute example mesh/gw1/example-gateway-route
 * ```
 */
public class GatewayRoute internal constructor(
    override val javaResource: com.pulumi.aws.appmesh.GatewayRoute,
) : KotlinCustomResource(javaResource, GatewayRouteMapper) {
    /**
     * ARN of the gateway route.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Creation date of the gateway route.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * Last update date of the gateway route.
     */
    public val lastUpdatedDate: Output<String>
        get() = javaResource.lastUpdatedDate().applyValue({ args0 -> args0 })

    /**
     * Name of the service mesh in which to create the gateway route. Must be between 1 and 255 characters in length.
     */
    public val meshName: Output<String>
        get() = javaResource.meshName().applyValue({ args0 -> args0 })

    /**
     * AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    public val meshOwner: Output<String>
        get() = javaResource.meshOwner().applyValue({ args0 -> args0 })

    /**
     * Name to use for the gateway route. Must be between 1 and 255 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource owner's AWS account ID.
     */
    public val resourceOwner: Output<String>
        get() = javaResource.resourceOwner().applyValue({ args0 -> args0 })

    /**
     * Gateway route specification to apply.
     */
    public val spec: Output<GatewayRouteSpec>
        get() = javaResource.spec().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Name of the virtual gateway to associate the gateway route with. Must be between 1 and 255 characters in length.
     */
    public val virtualGatewayName: Output<String>
        get() = javaResource.virtualGatewayName().applyValue({ args0 -> args0 })
}

public object GatewayRouteMapper : ResourceMapper<GatewayRoute> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appmesh.GatewayRoute::class == javaResource::class

    override fun map(javaResource: Resource): GatewayRoute = GatewayRoute(
        javaResource as
            com.pulumi.aws.appmesh.GatewayRoute,
    )
}

/**
 * @see [GatewayRoute].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GatewayRoute].
 */
public suspend fun gatewayRoute(
    name: String,
    block: suspend GatewayRouteResourceBuilder.() -> Unit,
): GatewayRoute {
    val builder = GatewayRouteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GatewayRoute].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gatewayRoute(name: String): GatewayRoute {
    val builder = GatewayRouteResourceBuilder()
    builder.name(name)
    return builder.build()
}
