@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin

import com.pulumi.aws.appmesh.GatewayRouteArgs.builder
import com.pulumi.aws.appmesh.kotlin.inputs.GatewayRouteSpecArgs
import com.pulumi.aws.appmesh.kotlin.inputs.GatewayRouteSpecArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS App Mesh gateway route resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appmesh.GatewayRoute("example", {
 *     name: "example-gateway-route",
 *     meshName: "example-service-mesh",
 *     virtualGatewayName: exampleAwsAppmeshVirtualGateway.name,
 *     spec: {
 *         httpRoute: {
 *             action: {
 *                 target: {
 *                     virtualService: {
 *                         virtualServiceName: exampleAwsAppmeshVirtualService.name,
 *                     },
 *                 },
 *             },
 *             match: {
 *                 prefix: "/",
 *             },
 *         },
 *     },
 *     tags: {
 *         Environment: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appmesh.GatewayRoute("example",
 *     name="example-gateway-route",
 *     mesh_name="example-service-mesh",
 *     virtual_gateway_name=example_aws_appmesh_virtual_gateway["name"],
 *     spec={
 *         "http_route": {
 *             "action": {
 *                 "target": {
 *                     "virtual_service": {
 *                         "virtual_service_name": example_aws_appmesh_virtual_service["name"],
 *                     },
 *                 },
 *             },
 *             "match": {
 *                 "prefix": "/",
 *             },
 *         },
 *     },
 *     tags={
 *         "Environment": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppMesh.GatewayRoute("example", new()
 *     {
 *         Name = "example-gateway-route",
 *         MeshName = "example-service-mesh",
 *         VirtualGatewayName = exampleAwsAppmeshVirtualGateway.Name,
 *         Spec = new Aws.AppMesh.Inputs.GatewayRouteSpecArgs
 *         {
 *             HttpRoute = new Aws.AppMesh.Inputs.GatewayRouteSpecHttpRouteArgs
 *             {
 *                 Action = new Aws.AppMesh.Inputs.GatewayRouteSpecHttpRouteActionArgs
 *                 {
 *                     Target = new Aws.AppMesh.Inputs.GatewayRouteSpecHttpRouteActionTargetArgs
 *                     {
 *                         VirtualService = new Aws.AppMesh.Inputs.GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs
 *                         {
 *                             VirtualServiceName = exampleAwsAppmeshVirtualService.Name,
 *                         },
 *                     },
 *                 },
 *                 Match = new Aws.AppMesh.Inputs.GatewayRouteSpecHttpRouteMatchArgs
 *                 {
 *                     Prefix = "/",
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Environment", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appmesh.NewGatewayRoute(ctx, "example", &appmesh.GatewayRouteArgs{
 * 			Name:               pulumi.String("example-gateway-route"),
 * 			MeshName:           pulumi.String("example-service-mesh"),
 * 			VirtualGatewayName: pulumi.Any(exampleAwsAppmeshVirtualGateway.Name),
 * 			Spec: &appmesh.GatewayRouteSpecArgs{
 * 				HttpRoute: &appmesh.GatewayRouteSpecHttpRouteArgs{
 * 					Action: &appmesh.GatewayRouteSpecHttpRouteActionArgs{
 * 						Target: &appmesh.GatewayRouteSpecHttpRouteActionTargetArgs{
 * 							VirtualService: &appmesh.GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs{
 * 								VirtualServiceName: pulumi.Any(exampleAwsAppmeshVirtualService.Name),
 * 							},
 * 						},
 * 					},
 * 					Match: &appmesh.GatewayRouteSpecHttpRouteMatchArgs{
 * 						Prefix: pulumi.String("/"),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.GatewayRoute;
 * import com.pulumi.aws.appmesh.GatewayRouteArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionTargetArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GatewayRoute("example", GatewayRouteArgs.builder()
 *             .name("example-gateway-route")
 *             .meshName("example-service-mesh")
 *             .virtualGatewayName(exampleAwsAppmeshVirtualGateway.name())
 *             .spec(GatewayRouteSpecArgs.builder()
 *                 .httpRoute(GatewayRouteSpecHttpRouteArgs.builder()
 *                     .action(GatewayRouteSpecHttpRouteActionArgs.builder()
 *                         .target(GatewayRouteSpecHttpRouteActionTargetArgs.builder()
 *                             .virtualService(GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs.builder()
 *                                 .virtualServiceName(exampleAwsAppmeshVirtualService.name())
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .match(GatewayRouteSpecHttpRouteMatchArgs.builder()
 *                         .prefix("/")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appmesh:GatewayRoute
 *     properties:
 *       name: example-gateway-route
 *       meshName: example-service-mesh
 *       virtualGatewayName: ${exampleAwsAppmeshVirtualGateway.name}
 *       spec:
 *         httpRoute:
 *           action:
 *             target:
 *               virtualService:
 *                 virtualServiceName: ${exampleAwsAppmeshVirtualService.name}
 *           match:
 *             prefix: /
 *       tags:
 *         Environment: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import App Mesh gateway routes using `mesh_name` and `virtual_gateway_name` together with the gateway route's `name`. For example:
 * ```sh
 * $ pulumi import aws:appmesh/gatewayRoute:GatewayRoute example mesh/gw1/example-gateway-route
 * ```
 * @property meshName Name of the service mesh in which to create the gateway route. Must be between 1 and 255 characters in length.
 * @property meshOwner AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
 * @property name Name to use for the gateway route. Must be between 1 and 255 characters in length.
 * @property spec Gateway route specification to apply.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property virtualGatewayName Name of the virtual gateway to associate the gateway route with. Must be between 1 and 255 characters in length.
 */
public data class GatewayRouteArgs(
    public val meshName: Output<String>? = null,
    public val meshOwner: Output<String>? = null,
    public val name: Output<String>? = null,
    public val spec: Output<GatewayRouteSpecArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualGatewayName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.GatewayRouteArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.GatewayRouteArgs =
        com.pulumi.aws.appmesh.GatewayRouteArgs.builder()
            .meshName(meshName?.applyValue({ args0 -> args0 }))
            .meshOwner(meshOwner?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .spec(spec?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualGatewayName(virtualGatewayName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteArgs].
 */
@PulumiTagMarker
public class GatewayRouteArgsBuilder internal constructor() {
    private var meshName: Output<String>? = null

    private var meshOwner: Output<String>? = null

    private var name: Output<String>? = null

    private var spec: Output<GatewayRouteSpecArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualGatewayName: Output<String>? = null

    /**
     * @param value Name of the service mesh in which to create the gateway route. Must be between 1 and 255 characters in length.
     */
    @JvmName("muaswjiqjfpdiwly")
    public suspend fun meshName(`value`: Output<String>) {
        this.meshName = value
    }

    /**
     * @param value AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("tyotaveljcgpcgsw")
    public suspend fun meshOwner(`value`: Output<String>) {
        this.meshOwner = value
    }

    /**
     * @param value Name to use for the gateway route. Must be between 1 and 255 characters in length.
     */
    @JvmName("nkpsmlxqaasyvlox")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gateway route specification to apply.
     */
    @JvmName("kdhcmbouvocekasy")
    public suspend fun spec(`value`: Output<GatewayRouteSpecArgs>) {
        this.spec = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("svhvgqdilauaxodr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the virtual gateway to associate the gateway route with. Must be between 1 and 255 characters in length.
     */
    @JvmName("dlqgbnctemsabhbb")
    public suspend fun virtualGatewayName(`value`: Output<String>) {
        this.virtualGatewayName = value
    }

    /**
     * @param value Name of the service mesh in which to create the gateway route. Must be between 1 and 255 characters in length.
     */
    @JvmName("avlxtqeaiertncij")
    public suspend fun meshName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.meshName = mapped
    }

    /**
     * @param value AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("rueskhmcxtkxxoiv")
    public suspend fun meshOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.meshOwner = mapped
    }

    /**
     * @param value Name to use for the gateway route. Must be between 1 and 255 characters in length.
     */
    @JvmName("lywosokcxonfvbxp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gateway route specification to apply.
     */
    @JvmName("fcirxfagrgmahxll")
    public suspend fun spec(`value`: GatewayRouteSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param argument Gateway route specification to apply.
     */
    @JvmName("nwaitrlvhfgplqfq")
    public suspend fun spec(argument: suspend GatewayRouteSpecArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spec = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("diywfuryqlkoheei")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xepqutlktfkvhecp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the virtual gateway to associate the gateway route with. Must be between 1 and 255 characters in length.
     */
    @JvmName("ahvdphdurptytywx")
    public suspend fun virtualGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualGatewayName = mapped
    }

    internal fun build(): GatewayRouteArgs = GatewayRouteArgs(
        meshName = meshName,
        meshOwner = meshOwner,
        name = name,
        spec = spec,
        tags = tags,
        virtualGatewayName = virtualGatewayName,
    )
}
