@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin

import com.pulumi.aws.appmesh.kotlin.outputs.MeshSpec
import com.pulumi.aws.appmesh.kotlin.outputs.MeshSpec.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Mesh].
 */
@PulumiTagMarker
public class MeshResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MeshArgs = MeshArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MeshArgsBuilder.() -> Unit) {
        val builder = MeshArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Mesh {
        val builtJavaResource = com.pulumi.aws.appmesh.Mesh(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Mesh(builtJavaResource)
    }
}

/**
 * Provides an AWS App Mesh service mesh resource.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const simple = new aws.appmesh.Mesh("simple", {name: "simpleapp"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * simple = aws.appmesh.Mesh("simple", name="simpleapp")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var simple = new Aws.AppMesh.Mesh("simple", new()
 *     {
 *         Name = "simpleapp",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appmesh.NewMesh(ctx, "simple", &appmesh.MeshArgs{
 * 			Name: pulumi.String("simpleapp"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.Mesh;
 * import com.pulumi.aws.appmesh.MeshArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var simple = new Mesh("simple", MeshArgs.builder()
 *             .name("simpleapp")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   simple:
 *     type: aws:appmesh:Mesh
 *     properties:
 *       name: simpleapp
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Egress Filter
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const simple = new aws.appmesh.Mesh("simple", {
 *     name: "simpleapp",
 *     spec: {
 *         egressFilter: {
 *             type: "ALLOW_ALL",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * simple = aws.appmesh.Mesh("simple",
 *     name="simpleapp",
 *     spec={
 *         "egress_filter": {
 *             "type": "ALLOW_ALL",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var simple = new Aws.AppMesh.Mesh("simple", new()
 *     {
 *         Name = "simpleapp",
 *         Spec = new Aws.AppMesh.Inputs.MeshSpecArgs
 *         {
 *             EgressFilter = new Aws.AppMesh.Inputs.MeshSpecEgressFilterArgs
 *             {
 *                 Type = "ALLOW_ALL",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appmesh.NewMesh(ctx, "simple", &appmesh.MeshArgs{
 * 			Name: pulumi.String("simpleapp"),
 * 			Spec: &appmesh.MeshSpecArgs{
 * 				EgressFilter: &appmesh.MeshSpecEgressFilterArgs{
 * 					Type: pulumi.String("ALLOW_ALL"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.Mesh;
 * import com.pulumi.aws.appmesh.MeshArgs;
 * import com.pulumi.aws.appmesh.inputs.MeshSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.MeshSpecEgressFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var simple = new Mesh("simple", MeshArgs.builder()
 *             .name("simpleapp")
 *             .spec(MeshSpecArgs.builder()
 *                 .egressFilter(MeshSpecEgressFilterArgs.builder()
 *                     .type("ALLOW_ALL")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   simple:
 *     type: aws:appmesh:Mesh
 *     properties:
 *       name: simpleapp
 *       spec:
 *         egressFilter:
 *           type: ALLOW_ALL
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import App Mesh service meshes using the `name`. For example:
 * ```sh
 * $ pulumi import aws:appmesh/mesh:Mesh simple simpleapp
 * ```
 */
public class Mesh internal constructor(
    override val javaResource: com.pulumi.aws.appmesh.Mesh,
) : KotlinCustomResource(javaResource, MeshMapper) {
    /**
     * ARN of the service mesh.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Creation date of the service mesh.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * Last update date of the service mesh.
     */
    public val lastUpdatedDate: Output<String>
        get() = javaResource.lastUpdatedDate().applyValue({ args0 -> args0 })

    /**
     * AWS account ID of the service mesh's owner.
     */
    public val meshOwner: Output<String>
        get() = javaResource.meshOwner().applyValue({ args0 -> args0 })

    /**
     * Name to use for the service mesh. Must be between 1 and 255 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource owner's AWS account ID.
     */
    public val resourceOwner: Output<String>
        get() = javaResource.resourceOwner().applyValue({ args0 -> args0 })

    /**
     * Service mesh specification to apply.
     */
    public val spec: Output<MeshSpec>?
        get() = javaResource.spec().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object MeshMapper : ResourceMapper<Mesh> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appmesh.Mesh::class == javaResource::class

    override fun map(javaResource: Resource): Mesh = Mesh(javaResource as com.pulumi.aws.appmesh.Mesh)
}

/**
 * @see [Mesh].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Mesh].
 */
public suspend fun mesh(name: String, block: suspend MeshResourceBuilder.() -> Unit): Mesh {
    val builder = MeshResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Mesh].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mesh(name: String): Mesh {
    val builder = MeshResourceBuilder()
    builder.name(name)
    return builder.build()
}
