@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin

import com.pulumi.aws.appmesh.MeshArgs.builder
import com.pulumi.aws.appmesh.kotlin.inputs.MeshSpecArgs
import com.pulumi.aws.appmesh.kotlin.inputs.MeshSpecArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS App Mesh service mesh resource.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const simple = new aws.appmesh.Mesh("simple", {name: "simpleapp"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * simple = aws.appmesh.Mesh("simple", name="simpleapp")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var simple = new Aws.AppMesh.Mesh("simple", new()
 *     {
 *         Name = "simpleapp",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appmesh.NewMesh(ctx, "simple", &appmesh.MeshArgs{
 * 			Name: pulumi.String("simpleapp"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.Mesh;
 * import com.pulumi.aws.appmesh.MeshArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var simple = new Mesh("simple", MeshArgs.builder()
 *             .name("simpleapp")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   simple:
 *     type: aws:appmesh:Mesh
 *     properties:
 *       name: simpleapp
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Egress Filter
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const simple = new aws.appmesh.Mesh("simple", {
 *     name: "simpleapp",
 *     spec: {
 *         egressFilter: {
 *             type: "ALLOW_ALL",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * simple = aws.appmesh.Mesh("simple",
 *     name="simpleapp",
 *     spec={
 *         "egress_filter": {
 *             "type": "ALLOW_ALL",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var simple = new Aws.AppMesh.Mesh("simple", new()
 *     {
 *         Name = "simpleapp",
 *         Spec = new Aws.AppMesh.Inputs.MeshSpecArgs
 *         {
 *             EgressFilter = new Aws.AppMesh.Inputs.MeshSpecEgressFilterArgs
 *             {
 *                 Type = "ALLOW_ALL",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appmesh.NewMesh(ctx, "simple", &appmesh.MeshArgs{
 * 			Name: pulumi.String("simpleapp"),
 * 			Spec: &appmesh.MeshSpecArgs{
 * 				EgressFilter: &appmesh.MeshSpecEgressFilterArgs{
 * 					Type: pulumi.String("ALLOW_ALL"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.Mesh;
 * import com.pulumi.aws.appmesh.MeshArgs;
 * import com.pulumi.aws.appmesh.inputs.MeshSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.MeshSpecEgressFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var simple = new Mesh("simple", MeshArgs.builder()
 *             .name("simpleapp")
 *             .spec(MeshSpecArgs.builder()
 *                 .egressFilter(MeshSpecEgressFilterArgs.builder()
 *                     .type("ALLOW_ALL")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   simple:
 *     type: aws:appmesh:Mesh
 *     properties:
 *       name: simpleapp
 *       spec:
 *         egressFilter:
 *           type: ALLOW_ALL
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import App Mesh service meshes using the `name`. For example:
 * ```sh
 * $ pulumi import aws:appmesh/mesh:Mesh simple simpleapp
 * ```
 * @property name Name to use for the service mesh. Must be between 1 and 255 characters in length.
 * @property spec Service mesh specification to apply.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class MeshArgs(
    public val name: Output<String>? = null,
    public val spec: Output<MeshSpecArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.MeshArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.MeshArgs = com.pulumi.aws.appmesh.MeshArgs.builder()
        .name(name?.applyValue({ args0 -> args0 }))
        .spec(spec?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [MeshArgs].
 */
@PulumiTagMarker
public class MeshArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var spec: Output<MeshSpecArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name to use for the service mesh. Must be between 1 and 255 characters in length.
     */
    @JvmName("lwxuctusqjidqpnb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Service mesh specification to apply.
     */
    @JvmName("embjnkdyxhpjpqkm")
    public suspend fun spec(`value`: Output<MeshSpecArgs>) {
        this.spec = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rmejxmsdatngmbut")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name to use for the service mesh. Must be between 1 and 255 characters in length.
     */
    @JvmName("alarwectdonnbgql")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Service mesh specification to apply.
     */
    @JvmName("bpudeuedupoldrxt")
    public suspend fun spec(`value`: MeshSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param argument Service mesh specification to apply.
     */
    @JvmName("rjwwliuxohmqsqrq")
    public suspend fun spec(argument: suspend MeshSpecArgsBuilder.() -> Unit) {
        val toBeMapped = MeshSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spec = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hphypfvbfdqpxryr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wbwxbknrgqtdqahu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MeshArgs = MeshArgs(
        name = name,
        spec = spec,
        tags = tags,
    )
}
