@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin

import com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpec
import com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpec.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VirtualGateway].
 */
@PulumiTagMarker
public class VirtualGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualGatewayArgs = VirtualGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualGatewayArgsBuilder.() -> Unit) {
        val builder = VirtualGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualGateway {
        val builtJavaResource = com.pulumi.aws.appmesh.VirtualGateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VirtualGateway(builtJavaResource)
    }
}

/**
 * Provides an AWS App Mesh virtual gateway resource.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appmesh.VirtualGateway("example", {
 *     name: "example-virtual-gateway",
 *     meshName: "example-service-mesh",
 *     spec: {
 *         listeners: [{
 *             portMapping: {
 *                 port: 8080,
 *                 protocol: "http",
 *             },
 *         }],
 *     },
 *     tags: {
 *         Environment: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appmesh.VirtualGateway("example",
 *     name="example-virtual-gateway",
 *     mesh_name="example-service-mesh",
 *     spec={
 *         "listeners": [{
 *             "port_mapping": {
 *                 "port": 8080,
 *                 "protocol": "http",
 *             },
 *         }],
 *     },
 *     tags={
 *         "Environment": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppMesh.VirtualGateway("example", new()
 *     {
 *         Name = "example-virtual-gateway",
 *         MeshName = "example-service-mesh",
 *         Spec = new Aws.AppMesh.Inputs.VirtualGatewaySpecArgs
 *         {
 *             Listeners = new[]
 *             {
 *                 new Aws.AppMesh.Inputs.VirtualGatewaySpecListenerArgs
 *                 {
 *                     PortMapping = new Aws.AppMesh.Inputs.VirtualGatewaySpecListenerPortMappingArgs
 *                     {
 *                         Port = 8080,
 *                         Protocol = "http",
 *                     },
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Environment", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appmesh.NewVirtualGateway(ctx, "example", &appmesh.VirtualGatewayArgs{
 * 			Name:     pulumi.String("example-virtual-gateway"),
 * 			MeshName: pulumi.String("example-service-mesh"),
 * 			Spec: &appmesh.VirtualGatewaySpecArgs{
 * 				Listeners: appmesh.VirtualGatewaySpecListenerArray{
 * 					&appmesh.VirtualGatewaySpecListenerArgs{
 * 						PortMapping: &appmesh.VirtualGatewaySpecListenerPortMappingArgs{
 * 							Port:     pulumi.Int(8080),
 * 							Protocol: pulumi.String("http"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.VirtualGateway;
 * import com.pulumi.aws.appmesh.VirtualGatewayArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VirtualGateway("example", VirtualGatewayArgs.builder()
 *             .name("example-virtual-gateway")
 *             .meshName("example-service-mesh")
 *             .spec(VirtualGatewaySpecArgs.builder()
 *                 .listeners(VirtualGatewaySpecListenerArgs.builder()
 *                     .portMapping(VirtualGatewaySpecListenerPortMappingArgs.builder()
 *                         .port(8080)
 *                         .protocol("http")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appmesh:VirtualGateway
 *     properties:
 *       name: example-virtual-gateway
 *       meshName: example-service-mesh
 *       spec:
 *         listeners:
 *           - portMapping:
 *               port: 8080
 *               protocol: http
 *       tags:
 *         Environment: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Access Logs and TLS
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appmesh.VirtualGateway("example", {
 *     name: "example-virtual-gateway",
 *     meshName: "example-service-mesh",
 *     spec: {
 *         listeners: [{
 *             portMapping: {
 *                 port: 8080,
 *                 protocol: "http",
 *             },
 *             tls: {
 *                 certificate: {
 *                     acm: {
 *                         certificateArn: exampleAwsAcmCertificate.arn,
 *                     },
 *                 },
 *                 mode: "STRICT",
 *             },
 *         }],
 *         logging: {
 *             accessLog: {
 *                 file: {
 *                     path: "/var/log/access.log",
 *                 },
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appmesh.VirtualGateway("example",
 *     name="example-virtual-gateway",
 *     mesh_name="example-service-mesh",
 *     spec={
 *         "listeners": [{
 *             "port_mapping": {
 *                 "port": 8080,
 *                 "protocol": "http",
 *             },
 *             "tls": {
 *                 "certificate": {
 *                     "acm": {
 *                         "certificate_arn": example_aws_acm_certificate["arn"],
 *                     },
 *                 },
 *                 "mode": "STRICT",
 *             },
 *         }],
 *         "logging": {
 *             "access_log": {
 *                 "file": {
 *                     "path": "/var/log/access.log",
 *                 },
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppMesh.VirtualGateway("example", new()
 *     {
 *         Name = "example-virtual-gateway",
 *         MeshName = "example-service-mesh",
 *         Spec = new Aws.AppMesh.Inputs.VirtualGatewaySpecArgs
 *         {
 *             Listeners = new[]
 *             {
 *                 new Aws.AppMesh.Inputs.VirtualGatewaySpecListenerArgs
 *                 {
 *                     PortMapping = new Aws.AppMesh.Inputs.VirtualGatewaySpecListenerPortMappingArgs
 *                     {
 *                         Port = 8080,
 *                         Protocol = "http",
 *                     },
 *                     Tls = new Aws.AppMesh.Inputs.VirtualGatewaySpecListenerTlsArgs
 *                     {
 *                         Certificate = new Aws.AppMesh.Inputs.VirtualGatewaySpecListenerTlsCertificateArgs
 *                         {
 *                             Acm = new Aws.AppMesh.Inputs.VirtualGatewaySpecListenerTlsCertificateAcmArgs
 *                             {
 *                                 CertificateArn = exampleAwsAcmCertificate.Arn,
 *                             },
 *                         },
 *                         Mode = "STRICT",
 *                     },
 *                 },
 *             },
 *             Logging = new Aws.AppMesh.Inputs.VirtualGatewaySpecLoggingArgs
 *             {
 *                 AccessLog = new Aws.AppMesh.Inputs.VirtualGatewaySpecLoggingAccessLogArgs
 *                 {
 *                     File = new Aws.AppMesh.Inputs.VirtualGatewaySpecLoggingAccessLogFileArgs
 *                     {
 *                         Path = "/var/log/access.log",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appmesh.NewVirtualGateway(ctx, "example", &appmesh.VirtualGatewayArgs{
 * 			Name:     pulumi.String("example-virtual-gateway"),
 * 			MeshName: pulumi.String("example-service-mesh"),
 * 			Spec: &appmesh.VirtualGatewaySpecArgs{
 * 				Listeners: appmesh.VirtualGatewaySpecListenerArray{
 * 					&appmesh.VirtualGatewaySpecListenerArgs{
 * 						PortMapping: &appmesh.VirtualGatewaySpecListenerPortMappingArgs{
 * 							Port:     pulumi.Int(8080),
 * 							Protocol: pulumi.String("http"),
 * 						},
 * 						Tls: &appmesh.VirtualGatewaySpecListenerTlsArgs{
 * 							Certificate: &appmesh.VirtualGatewaySpecListenerTlsCertificateArgs{
 * 								Acm: &appmesh.VirtualGatewaySpecListenerTlsCertificateAcmArgs{
 * 									CertificateArn: pulumi.Any(exampleAwsAcmCertificate.Arn),
 * 								},
 * 							},
 * 							Mode: pulumi.String("STRICT"),
 * 						},
 * 					},
 * 				},
 * 				Logging: &appmesh.VirtualGatewaySpecLoggingArgs{
 * 					AccessLog: &appmesh.VirtualGatewaySpecLoggingAccessLogArgs{
 * 						File: &appmesh.VirtualGatewaySpecLoggingAccessLogFileArgs{
 * 							Path: pulumi.String("/var/log/access.log"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.VirtualGateway;
 * import com.pulumi.aws.appmesh.VirtualGatewayArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingAccessLogArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingAccessLogFileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VirtualGateway("example", VirtualGatewayArgs.builder()
 *             .name("example-virtual-gateway")
 *             .meshName("example-service-mesh")
 *             .spec(VirtualGatewaySpecArgs.builder()
 *                 .listeners(VirtualGatewaySpecListenerArgs.builder()
 *                     .portMapping(VirtualGatewaySpecListenerPortMappingArgs.builder()
 *                         .port(8080)
 *                         .protocol("http")
 *                         .build())
 *                     .tls(VirtualGatewaySpecListenerTlsArgs.builder()
 *                         .certificate(VirtualGatewaySpecListenerTlsCertificateArgs.builder()
 *                             .acm(VirtualGatewaySpecListenerTlsCertificateAcmArgs.builder()
 *                                 .certificateArn(exampleAwsAcmCertificate.arn())
 *                                 .build())
 *                             .build())
 *                         .mode("STRICT")
 *                         .build())
 *                     .build())
 *                 .logging(VirtualGatewaySpecLoggingArgs.builder()
 *                     .accessLog(VirtualGatewaySpecLoggingAccessLogArgs.builder()
 *                         .file(VirtualGatewaySpecLoggingAccessLogFileArgs.builder()
 *                             .path("/var/log/access.log")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appmesh:VirtualGateway
 *     properties:
 *       name: example-virtual-gateway
 *       meshName: example-service-mesh
 *       spec:
 *         listeners:
 *           - portMapping:
 *               port: 8080
 *               protocol: http
 *             tls:
 *               certificate:
 *                 acm:
 *                   certificateArn: ${exampleAwsAcmCertificate.arn}
 *               mode: STRICT
 *         logging:
 *           accessLog:
 *             file:
 *               path: /var/log/access.log
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import App Mesh virtual gateway using `mesh_name` together with the virtual gateway's `name`. For example:
 * ```sh
 * $ pulumi import aws:appmesh/virtualGateway:VirtualGateway example mesh/gw1
 * ```
 */
public class VirtualGateway internal constructor(
    override val javaResource: com.pulumi.aws.appmesh.VirtualGateway,
) : KotlinCustomResource(javaResource, VirtualGatewayMapper) {
    /**
     * ARN of the virtual gateway.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Creation date of the virtual gateway.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * Last update date of the virtual gateway.
     */
    public val lastUpdatedDate: Output<String>
        get() = javaResource.lastUpdatedDate().applyValue({ args0 -> args0 })

    /**
     * Name of the service mesh in which to create the virtual gateway. Must be between 1 and 255 characters in length.
     */
    public val meshName: Output<String>
        get() = javaResource.meshName().applyValue({ args0 -> args0 })

    /**
     * AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    public val meshOwner: Output<String>
        get() = javaResource.meshOwner().applyValue({ args0 -> args0 })

    /**
     * Name to use for the virtual gateway. Must be between 1 and 255 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource owner's AWS account ID.
     */
    public val resourceOwner: Output<String>
        get() = javaResource.resourceOwner().applyValue({ args0 -> args0 })

    /**
     * Virtual gateway specification to apply.
     */
    public val spec: Output<VirtualGatewaySpec>
        get() = javaResource.spec().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VirtualGatewayMapper : ResourceMapper<VirtualGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appmesh.VirtualGateway::class == javaResource::class

    override fun map(javaResource: Resource): VirtualGateway = VirtualGateway(
        javaResource as
            com.pulumi.aws.appmesh.VirtualGateway,
    )
}

/**
 * @see [VirtualGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualGateway].
 */
public suspend fun virtualGateway(
    name: String,
    block: suspend VirtualGatewayResourceBuilder.() -> Unit,
): VirtualGateway {
    val builder = VirtualGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualGateway(name: String): VirtualGateway {
    val builder = VirtualGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
