@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin

import com.pulumi.aws.appmesh.VirtualGatewayArgs.builder
import com.pulumi.aws.appmesh.kotlin.inputs.VirtualGatewaySpecArgs
import com.pulumi.aws.appmesh.kotlin.inputs.VirtualGatewaySpecArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS App Mesh virtual gateway resource.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appmesh.VirtualGateway("example", {
 *     name: "example-virtual-gateway",
 *     meshName: "example-service-mesh",
 *     spec: {
 *         listeners: [{
 *             portMapping: {
 *                 port: 8080,
 *                 protocol: "http",
 *             },
 *         }],
 *     },
 *     tags: {
 *         Environment: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appmesh.VirtualGateway("example",
 *     name="example-virtual-gateway",
 *     mesh_name="example-service-mesh",
 *     spec={
 *         "listeners": [{
 *             "port_mapping": {
 *                 "port": 8080,
 *                 "protocol": "http",
 *             },
 *         }],
 *     },
 *     tags={
 *         "Environment": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppMesh.VirtualGateway("example", new()
 *     {
 *         Name = "example-virtual-gateway",
 *         MeshName = "example-service-mesh",
 *         Spec = new Aws.AppMesh.Inputs.VirtualGatewaySpecArgs
 *         {
 *             Listeners = new[]
 *             {
 *                 new Aws.AppMesh.Inputs.VirtualGatewaySpecListenerArgs
 *                 {
 *                     PortMapping = new Aws.AppMesh.Inputs.VirtualGatewaySpecListenerPortMappingArgs
 *                     {
 *                         Port = 8080,
 *                         Protocol = "http",
 *                     },
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Environment", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appmesh.NewVirtualGateway(ctx, "example", &appmesh.VirtualGatewayArgs{
 * 			Name:     pulumi.String("example-virtual-gateway"),
 * 			MeshName: pulumi.String("example-service-mesh"),
 * 			Spec: &appmesh.VirtualGatewaySpecArgs{
 * 				Listeners: appmesh.VirtualGatewaySpecListenerArray{
 * 					&appmesh.VirtualGatewaySpecListenerArgs{
 * 						PortMapping: &appmesh.VirtualGatewaySpecListenerPortMappingArgs{
 * 							Port:     pulumi.Int(8080),
 * 							Protocol: pulumi.String("http"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.VirtualGateway;
 * import com.pulumi.aws.appmesh.VirtualGatewayArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VirtualGateway("example", VirtualGatewayArgs.builder()
 *             .name("example-virtual-gateway")
 *             .meshName("example-service-mesh")
 *             .spec(VirtualGatewaySpecArgs.builder()
 *                 .listeners(VirtualGatewaySpecListenerArgs.builder()
 *                     .portMapping(VirtualGatewaySpecListenerPortMappingArgs.builder()
 *                         .port(8080)
 *                         .protocol("http")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appmesh:VirtualGateway
 *     properties:
 *       name: example-virtual-gateway
 *       meshName: example-service-mesh
 *       spec:
 *         listeners:
 *           - portMapping:
 *               port: 8080
 *               protocol: http
 *       tags:
 *         Environment: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Access Logs and TLS
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appmesh.VirtualGateway("example", {
 *     name: "example-virtual-gateway",
 *     meshName: "example-service-mesh",
 *     spec: {
 *         listeners: [{
 *             portMapping: {
 *                 port: 8080,
 *                 protocol: "http",
 *             },
 *             tls: {
 *                 certificate: {
 *                     acm: {
 *                         certificateArn: exampleAwsAcmCertificate.arn,
 *                     },
 *                 },
 *                 mode: "STRICT",
 *             },
 *         }],
 *         logging: {
 *             accessLog: {
 *                 file: {
 *                     path: "/var/log/access.log",
 *                 },
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appmesh.VirtualGateway("example",
 *     name="example-virtual-gateway",
 *     mesh_name="example-service-mesh",
 *     spec={
 *         "listeners": [{
 *             "port_mapping": {
 *                 "port": 8080,
 *                 "protocol": "http",
 *             },
 *             "tls": {
 *                 "certificate": {
 *                     "acm": {
 *                         "certificate_arn": example_aws_acm_certificate["arn"],
 *                     },
 *                 },
 *                 "mode": "STRICT",
 *             },
 *         }],
 *         "logging": {
 *             "access_log": {
 *                 "file": {
 *                     "path": "/var/log/access.log",
 *                 },
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppMesh.VirtualGateway("example", new()
 *     {
 *         Name = "example-virtual-gateway",
 *         MeshName = "example-service-mesh",
 *         Spec = new Aws.AppMesh.Inputs.VirtualGatewaySpecArgs
 *         {
 *             Listeners = new[]
 *             {
 *                 new Aws.AppMesh.Inputs.VirtualGatewaySpecListenerArgs
 *                 {
 *                     PortMapping = new Aws.AppMesh.Inputs.VirtualGatewaySpecListenerPortMappingArgs
 *                     {
 *                         Port = 8080,
 *                         Protocol = "http",
 *                     },
 *                     Tls = new Aws.AppMesh.Inputs.VirtualGatewaySpecListenerTlsArgs
 *                     {
 *                         Certificate = new Aws.AppMesh.Inputs.VirtualGatewaySpecListenerTlsCertificateArgs
 *                         {
 *                             Acm = new Aws.AppMesh.Inputs.VirtualGatewaySpecListenerTlsCertificateAcmArgs
 *                             {
 *                                 CertificateArn = exampleAwsAcmCertificate.Arn,
 *                             },
 *                         },
 *                         Mode = "STRICT",
 *                     },
 *                 },
 *             },
 *             Logging = new Aws.AppMesh.Inputs.VirtualGatewaySpecLoggingArgs
 *             {
 *                 AccessLog = new Aws.AppMesh.Inputs.VirtualGatewaySpecLoggingAccessLogArgs
 *                 {
 *                     File = new Aws.AppMesh.Inputs.VirtualGatewaySpecLoggingAccessLogFileArgs
 *                     {
 *                         Path = "/var/log/access.log",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appmesh.NewVirtualGateway(ctx, "example", &appmesh.VirtualGatewayArgs{
 * 			Name:     pulumi.String("example-virtual-gateway"),
 * 			MeshName: pulumi.String("example-service-mesh"),
 * 			Spec: &appmesh.VirtualGatewaySpecArgs{
 * 				Listeners: appmesh.VirtualGatewaySpecListenerArray{
 * 					&appmesh.VirtualGatewaySpecListenerArgs{
 * 						PortMapping: &appmesh.VirtualGatewaySpecListenerPortMappingArgs{
 * 							Port:     pulumi.Int(8080),
 * 							Protocol: pulumi.String("http"),
 * 						},
 * 						Tls: &appmesh.VirtualGatewaySpecListenerTlsArgs{
 * 							Certificate: &appmesh.VirtualGatewaySpecListenerTlsCertificateArgs{
 * 								Acm: &appmesh.VirtualGatewaySpecListenerTlsCertificateAcmArgs{
 * 									CertificateArn: pulumi.Any(exampleAwsAcmCertificate.Arn),
 * 								},
 * 							},
 * 							Mode: pulumi.String("STRICT"),
 * 						},
 * 					},
 * 				},
 * 				Logging: &appmesh.VirtualGatewaySpecLoggingArgs{
 * 					AccessLog: &appmesh.VirtualGatewaySpecLoggingAccessLogArgs{
 * 						File: &appmesh.VirtualGatewaySpecLoggingAccessLogFileArgs{
 * 							Path: pulumi.String("/var/log/access.log"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.VirtualGateway;
 * import com.pulumi.aws.appmesh.VirtualGatewayArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingAccessLogArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingAccessLogFileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VirtualGateway("example", VirtualGatewayArgs.builder()
 *             .name("example-virtual-gateway")
 *             .meshName("example-service-mesh")
 *             .spec(VirtualGatewaySpecArgs.builder()
 *                 .listeners(VirtualGatewaySpecListenerArgs.builder()
 *                     .portMapping(VirtualGatewaySpecListenerPortMappingArgs.builder()
 *                         .port(8080)
 *                         .protocol("http")
 *                         .build())
 *                     .tls(VirtualGatewaySpecListenerTlsArgs.builder()
 *                         .certificate(VirtualGatewaySpecListenerTlsCertificateArgs.builder()
 *                             .acm(VirtualGatewaySpecListenerTlsCertificateAcmArgs.builder()
 *                                 .certificateArn(exampleAwsAcmCertificate.arn())
 *                                 .build())
 *                             .build())
 *                         .mode("STRICT")
 *                         .build())
 *                     .build())
 *                 .logging(VirtualGatewaySpecLoggingArgs.builder()
 *                     .accessLog(VirtualGatewaySpecLoggingAccessLogArgs.builder()
 *                         .file(VirtualGatewaySpecLoggingAccessLogFileArgs.builder()
 *                             .path("/var/log/access.log")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appmesh:VirtualGateway
 *     properties:
 *       name: example-virtual-gateway
 *       meshName: example-service-mesh
 *       spec:
 *         listeners:
 *           - portMapping:
 *               port: 8080
 *               protocol: http
 *             tls:
 *               certificate:
 *                 acm:
 *                   certificateArn: ${exampleAwsAcmCertificate.arn}
 *               mode: STRICT
 *         logging:
 *           accessLog:
 *             file:
 *               path: /var/log/access.log
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import App Mesh virtual gateway using `mesh_name` together with the virtual gateway's `name`. For example:
 * ```sh
 * $ pulumi import aws:appmesh/virtualGateway:VirtualGateway example mesh/gw1
 * ```
 * @property meshName Name of the service mesh in which to create the virtual gateway. Must be between 1 and 255 characters in length.
 * @property meshOwner AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
 * @property name Name to use for the virtual gateway. Must be between 1 and 255 characters in length.
 * @property spec Virtual gateway specification to apply.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VirtualGatewayArgs(
    public val meshName: Output<String>? = null,
    public val meshOwner: Output<String>? = null,
    public val name: Output<String>? = null,
    public val spec: Output<VirtualGatewaySpecArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.VirtualGatewayArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.VirtualGatewayArgs =
        com.pulumi.aws.appmesh.VirtualGatewayArgs.builder()
            .meshName(meshName?.applyValue({ args0 -> args0 }))
            .meshOwner(meshOwner?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .spec(spec?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VirtualGatewayArgs].
 */
@PulumiTagMarker
public class VirtualGatewayArgsBuilder internal constructor() {
    private var meshName: Output<String>? = null

    private var meshOwner: Output<String>? = null

    private var name: Output<String>? = null

    private var spec: Output<VirtualGatewaySpecArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the service mesh in which to create the virtual gateway. Must be between 1 and 255 characters in length.
     */
    @JvmName("xmeqrfvoytjadkct")
    public suspend fun meshName(`value`: Output<String>) {
        this.meshName = value
    }

    /**
     * @param value AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("xvdawthkwtqjfmtk")
    public suspend fun meshOwner(`value`: Output<String>) {
        this.meshOwner = value
    }

    /**
     * @param value Name to use for the virtual gateway. Must be between 1 and 255 characters in length.
     */
    @JvmName("iubamuaxnmkmfmjo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Virtual gateway specification to apply.
     */
    @JvmName("kvfgavumamyimadq")
    public suspend fun spec(`value`: Output<VirtualGatewaySpecArgs>) {
        this.spec = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("daqhawngmorwpsrd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the service mesh in which to create the virtual gateway. Must be between 1 and 255 characters in length.
     */
    @JvmName("xkardkijmfvkbyee")
    public suspend fun meshName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.meshName = mapped
    }

    /**
     * @param value AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("sdqwysbwtkvemteb")
    public suspend fun meshOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.meshOwner = mapped
    }

    /**
     * @param value Name to use for the virtual gateway. Must be between 1 and 255 characters in length.
     */
    @JvmName("aihhksnjyadfoxht")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Virtual gateway specification to apply.
     */
    @JvmName("vbbyuqlpviojqunq")
    public suspend fun spec(`value`: VirtualGatewaySpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param argument Virtual gateway specification to apply.
     */
    @JvmName("wmdhdpoprotvrecr")
    public suspend fun spec(argument: suspend VirtualGatewaySpecArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spec = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jahbsuwueulhsrmf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fugjfbkkwsqlqwxw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VirtualGatewayArgs = VirtualGatewayArgs(
        meshName = meshName,
        meshOwner = meshOwner,
        name = name,
        spec = spec,
        tags = tags,
    )
}
