@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin

import com.pulumi.aws.appmesh.VirtualRouterArgs.builder
import com.pulumi.aws.appmesh.kotlin.inputs.VirtualRouterSpecArgs
import com.pulumi.aws.appmesh.kotlin.inputs.VirtualRouterSpecArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS App Mesh virtual router resource.
 * ## Breaking Changes
 * Because of backward incompatible API changes (read [here](https://github&#46;com/awslabs/aws-app-mesh-examples/issues/92) and [here](https://github.com/awslabs/aws-app-mesh-examples/issues/94)), `aws.appmesh.VirtualRouter` resource definitions created with provider versions earlier than v2.3.0 will need to be modified:
 * * Remove service `service_names` from the `spec` argument. AWS has created a `aws.appmesh.VirtualService` resource for each service name. Import these resource using `pulumi import`.
 * * Add a `listener` configuration block to the `spec` argument.
 * The state associated with existing resources will automatically be migrated.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const serviceb = new aws.appmesh.VirtualRouter("serviceb", {
 *     name: "serviceB",
 *     meshName: simple.id,
 *     spec: {
 *         listeners: [{
 *             portMapping: {
 *                 port: 8080,
 *                 protocol: "http",
 *             },
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * serviceb = aws.appmesh.VirtualRouter("serviceb",
 *     name="serviceB",
 *     mesh_name=simple["id"],
 *     spec={
 *         "listeners": [{
 *             "port_mapping": {
 *                 "port": 8080,
 *                 "protocol": "http",
 *             },
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceb = new Aws.AppMesh.VirtualRouter("serviceb", new()
 *     {
 *         Name = "serviceB",
 *         MeshName = simple.Id,
 *         Spec = new Aws.AppMesh.Inputs.VirtualRouterSpecArgs
 *         {
 *             Listeners = new[]
 *             {
 *                 new Aws.AppMesh.Inputs.VirtualRouterSpecListenerArgs
 *                 {
 *                     PortMapping = new Aws.AppMesh.Inputs.VirtualRouterSpecListenerPortMappingArgs
 *                     {
 *                         Port = 8080,
 *                         Protocol = "http",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appmesh.NewVirtualRouter(ctx, "serviceb", &appmesh.VirtualRouterArgs{
 * 			Name:     pulumi.String("serviceB"),
 * 			MeshName: pulumi.Any(simple.Id),
 * 			Spec: &appmesh.VirtualRouterSpecArgs{
 * 				Listeners: appmesh.VirtualRouterSpecListenerArray{
 * 					&appmesh.VirtualRouterSpecListenerArgs{
 * 						PortMapping: &appmesh.VirtualRouterSpecListenerPortMappingArgs{
 * 							Port:     pulumi.Int(8080),
 * 							Protocol: pulumi.String("http"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.VirtualRouter;
 * import com.pulumi.aws.appmesh.VirtualRouterArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualRouterSpecArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceb = new VirtualRouter("serviceb", VirtualRouterArgs.builder()
 *             .name("serviceB")
 *             .meshName(simple.id())
 *             .spec(VirtualRouterSpecArgs.builder()
 *                 .listeners(VirtualRouterSpecListenerArgs.builder()
 *                     .portMapping(VirtualRouterSpecListenerPortMappingArgs.builder()
 *                         .port(8080)
 *                         .protocol("http")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   serviceb:
 *     type: aws:appmesh:VirtualRouter
 *     properties:
 *       name: serviceB
 *       meshName: ${simple.id}
 *       spec:
 *         listeners:
 *           - portMapping:
 *               port: 8080
 *               protocol: http
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import App Mesh virtual routers using `mesh_name` together with the virtual router's `name`. For example:
 * ```sh
 * $ pulumi import aws:appmesh/virtualRouter:VirtualRouter serviceb simpleapp/serviceB
 * ```
 * @property meshName Name of the service mesh in which to create the virtual router. Must be between 1 and 255 characters in length.
 * @property meshOwner AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
 * @property name Name to use for the virtual router. Must be between 1 and 255 characters in length.
 * @property spec Virtual router specification to apply.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VirtualRouterArgs(
    public val meshName: Output<String>? = null,
    public val meshOwner: Output<String>? = null,
    public val name: Output<String>? = null,
    public val spec: Output<VirtualRouterSpecArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.VirtualRouterArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.VirtualRouterArgs =
        com.pulumi.aws.appmesh.VirtualRouterArgs.builder()
            .meshName(meshName?.applyValue({ args0 -> args0 }))
            .meshOwner(meshOwner?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .spec(spec?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VirtualRouterArgs].
 */
@PulumiTagMarker
public class VirtualRouterArgsBuilder internal constructor() {
    private var meshName: Output<String>? = null

    private var meshOwner: Output<String>? = null

    private var name: Output<String>? = null

    private var spec: Output<VirtualRouterSpecArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the service mesh in which to create the virtual router. Must be between 1 and 255 characters in length.
     */
    @JvmName("dsfrxsvubdepuapk")
    public suspend fun meshName(`value`: Output<String>) {
        this.meshName = value
    }

    /**
     * @param value AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("obtkxhfdtsxlkaov")
    public suspend fun meshOwner(`value`: Output<String>) {
        this.meshOwner = value
    }

    /**
     * @param value Name to use for the virtual router. Must be between 1 and 255 characters in length.
     */
    @JvmName("jlrpinhqdwiylutx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Virtual router specification to apply.
     */
    @JvmName("prbjnginuxlmrmxr")
    public suspend fun spec(`value`: Output<VirtualRouterSpecArgs>) {
        this.spec = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hxtngasxmhdgbppb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the service mesh in which to create the virtual router. Must be between 1 and 255 characters in length.
     */
    @JvmName("jypygxphpgowbslh")
    public suspend fun meshName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.meshName = mapped
    }

    /**
     * @param value AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("wbmtsxrkmmnabhcu")
    public suspend fun meshOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.meshOwner = mapped
    }

    /**
     * @param value Name to use for the virtual router. Must be between 1 and 255 characters in length.
     */
    @JvmName("vidqtrmeijjcimop")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Virtual router specification to apply.
     */
    @JvmName("nmpitnncplceiyjg")
    public suspend fun spec(`value`: VirtualRouterSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param argument Virtual router specification to apply.
     */
    @JvmName("yutwrptiwhklvhej")
    public suspend fun spec(argument: suspend VirtualRouterSpecArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualRouterSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spec = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fvgadsmduhkmyxtu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hygcgsbsaauedcra")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VirtualRouterArgs = VirtualRouterArgs(
        meshName = meshName,
        meshOwner = meshOwner,
        name = name,
        spec = spec,
        tags = tags,
    )
}
