@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin

import com.pulumi.aws.appmesh.kotlin.outputs.VirtualServiceSpec
import com.pulumi.aws.appmesh.kotlin.outputs.VirtualServiceSpec.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VirtualService].
 */
@PulumiTagMarker
public class VirtualServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualServiceArgs = VirtualServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualServiceArgsBuilder.() -> Unit) {
        val builder = VirtualServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualService {
        val builtJavaResource = com.pulumi.aws.appmesh.VirtualService(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VirtualService(builtJavaResource)
    }
}

/**
 * Provides an AWS App Mesh virtual service resource.
 * ## Example Usage
 * ### Virtual Node Provider
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const servicea = new aws.appmesh.VirtualService("servicea", {
 *     name: "servicea.simpleapp.local",
 *     meshName: simple.id,
 *     spec: {
 *         provider: {
 *             virtualNode: {
 *                 virtualNodeName: serviceb1.name,
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * servicea = aws.appmesh.VirtualService("servicea",
 *     name="servicea.simpleapp.local",
 *     mesh_name=simple["id"],
 *     spec={
 *         "provider": {
 *             "virtual_node": {
 *                 "virtual_node_name": serviceb1["name"],
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var servicea = new Aws.AppMesh.VirtualService("servicea", new()
 *     {
 *         Name = "servicea.simpleapp.local",
 *         MeshName = simple.Id,
 *         Spec = new Aws.AppMesh.Inputs.VirtualServiceSpecArgs
 *         {
 *             Provider = new Aws.AppMesh.Inputs.VirtualServiceSpecProviderArgs
 *             {
 *                 VirtualNode = new Aws.AppMesh.Inputs.VirtualServiceSpecProviderVirtualNodeArgs
 *                 {
 *                     VirtualNodeName = serviceb1.Name,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appmesh.NewVirtualService(ctx, "servicea", &appmesh.VirtualServiceArgs{
 * 			Name:     pulumi.String("servicea.simpleapp.local"),
 * 			MeshName: pulumi.Any(simple.Id),
 * 			Spec: &appmesh.VirtualServiceSpecArgs{
 * 				Provider: &appmesh.VirtualServiceSpecProviderArgs{
 * 					VirtualNode: &appmesh.VirtualServiceSpecProviderVirtualNodeArgs{
 * 						VirtualNodeName: pulumi.Any(serviceb1.Name),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.VirtualService;
 * import com.pulumi.aws.appmesh.VirtualServiceArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualServiceSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderVirtualNodeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var servicea = new VirtualService("servicea", VirtualServiceArgs.builder()
 *             .name("servicea.simpleapp.local")
 *             .meshName(simple.id())
 *             .spec(VirtualServiceSpecArgs.builder()
 *                 .provider(VirtualServiceSpecProviderArgs.builder()
 *                     .virtualNode(VirtualServiceSpecProviderVirtualNodeArgs.builder()
 *                         .virtualNodeName(serviceb1.name())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   servicea:
 *     type: aws:appmesh:VirtualService
 *     properties:
 *       name: servicea.simpleapp.local
 *       meshName: ${simple.id}
 *       spec:
 *         provider:
 *           virtualNode:
 *             virtualNodeName: ${serviceb1.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Virtual Router Provider
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const servicea = new aws.appmesh.VirtualService("servicea", {
 *     name: "servicea.simpleapp.local",
 *     meshName: simple.id,
 *     spec: {
 *         provider: {
 *             virtualRouter: {
 *                 virtualRouterName: serviceb.name,
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * servicea = aws.appmesh.VirtualService("servicea",
 *     name="servicea.simpleapp.local",
 *     mesh_name=simple["id"],
 *     spec={
 *         "provider": {
 *             "virtual_router": {
 *                 "virtual_router_name": serviceb["name"],
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var servicea = new Aws.AppMesh.VirtualService("servicea", new()
 *     {
 *         Name = "servicea.simpleapp.local",
 *         MeshName = simple.Id,
 *         Spec = new Aws.AppMesh.Inputs.VirtualServiceSpecArgs
 *         {
 *             Provider = new Aws.AppMesh.Inputs.VirtualServiceSpecProviderArgs
 *             {
 *                 VirtualRouter = new Aws.AppMesh.Inputs.VirtualServiceSpecProviderVirtualRouterArgs
 *                 {
 *                     VirtualRouterName = serviceb.Name,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appmesh"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appmesh.NewVirtualService(ctx, "servicea", &appmesh.VirtualServiceArgs{
 * 			Name:     pulumi.String("servicea.simpleapp.local"),
 * 			MeshName: pulumi.Any(simple.Id),
 * 			Spec: &appmesh.VirtualServiceSpecArgs{
 * 				Provider: &appmesh.VirtualServiceSpecProviderArgs{
 * 					VirtualRouter: &appmesh.VirtualServiceSpecProviderVirtualRouterArgs{
 * 						VirtualRouterName: pulumi.Any(serviceb.Name),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.VirtualService;
 * import com.pulumi.aws.appmesh.VirtualServiceArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualServiceSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderVirtualRouterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var servicea = new VirtualService("servicea", VirtualServiceArgs.builder()
 *             .name("servicea.simpleapp.local")
 *             .meshName(simple.id())
 *             .spec(VirtualServiceSpecArgs.builder()
 *                 .provider(VirtualServiceSpecProviderArgs.builder()
 *                     .virtualRouter(VirtualServiceSpecProviderVirtualRouterArgs.builder()
 *                         .virtualRouterName(serviceb.name())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   servicea:
 *     type: aws:appmesh:VirtualService
 *     properties:
 *       name: servicea.simpleapp.local
 *       meshName: ${simple.id}
 *       spec:
 *         provider:
 *           virtualRouter:
 *             virtualRouterName: ${serviceb.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import App Mesh virtual services using `mesh_name` together with the virtual service's `name`. For example:
 * ```sh
 * $ pulumi import aws:appmesh/virtualService:VirtualService servicea simpleapp/servicea.simpleapp.local
 * ```
 */
public class VirtualService internal constructor(
    override val javaResource: com.pulumi.aws.appmesh.VirtualService,
) : KotlinCustomResource(javaResource, VirtualServiceMapper) {
    /**
     * ARN of the virtual service.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Creation date of the virtual service.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * Last update date of the virtual service.
     */
    public val lastUpdatedDate: Output<String>
        get() = javaResource.lastUpdatedDate().applyValue({ args0 -> args0 })

    /**
     * Name of the service mesh in which to create the virtual service. Must be between 1 and 255 characters in length.
     */
    public val meshName: Output<String>
        get() = javaResource.meshName().applyValue({ args0 -> args0 })

    /**
     * AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    public val meshOwner: Output<String>
        get() = javaResource.meshOwner().applyValue({ args0 -> args0 })

    /**
     * Name to use for the virtual service. Must be between 1 and 255 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource owner's AWS account ID.
     */
    public val resourceOwner: Output<String>
        get() = javaResource.resourceOwner().applyValue({ args0 -> args0 })

    /**
     * Virtual service specification to apply.
     */
    public val spec: Output<VirtualServiceSpec>
        get() = javaResource.spec().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VirtualServiceMapper : ResourceMapper<VirtualService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appmesh.VirtualService::class == javaResource::class

    override fun map(javaResource: Resource): VirtualService = VirtualService(
        javaResource as
            com.pulumi.aws.appmesh.VirtualService,
    )
}

/**
 * @see [VirtualService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualService].
 */
public suspend fun virtualService(
    name: String,
    block: suspend VirtualServiceResourceBuilder.() -> Unit,
): VirtualService {
    val builder = VirtualServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualService(name: String): VirtualService {
    val builder = VirtualServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
