@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecGrpcRouteMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property port The port number to match from the request.
 * @property serviceName Fully qualified domain name for the service to match from the request.
 */
public data class GatewayRouteSpecGrpcRouteMatchArgs(
    public val port: Output<Int>? = null,
    public val serviceName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecGrpcRouteMatchArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecGrpcRouteMatchArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecGrpcRouteMatchArgs.builder()
            .port(port?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteSpecGrpcRouteMatchArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecGrpcRouteMatchArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The port number to match from the request.
     */
    @JvmName("jkksopxsvcthpbua")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Fully qualified domain name for the service to match from the request.
     */
    @JvmName("nmufufhtbpxfjyqu")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The port number to match from the request.
     */
    @JvmName("odxxlxyclnwwllpc")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Fully qualified domain name for the service to match from the request.
     */
    @JvmName("yefiukuiullbgajs")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): GatewayRouteSpecGrpcRouteMatchArgs = GatewayRouteSpecGrpcRouteMatchArgs(
        port = port,
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
