@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionRewriteHostnameArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultTargetHostname Default target host name to write to. Valid values: `ENABLED`, `DISABLED`.
 */
public data class GatewayRouteSpecHttp2RouteActionRewriteHostnameArgs(
    public val defaultTargetHostname: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionRewriteHostnameArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionRewriteHostnameArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionRewriteHostnameArgs.builder()
            .defaultTargetHostname(defaultTargetHostname.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteSpecHttp2RouteActionRewriteHostnameArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttp2RouteActionRewriteHostnameArgsBuilder internal constructor() {
    private var defaultTargetHostname: Output<String>? = null

    /**
     * @param value Default target host name to write to. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("owqwmhfmpixqnhqj")
    public suspend fun defaultTargetHostname(`value`: Output<String>) {
        this.defaultTargetHostname = value
    }

    /**
     * @param value Default target host name to write to. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("drmeasomokswtens")
    public suspend fun defaultTargetHostname(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultTargetHostname = mapped
    }

    internal fun build(): GatewayRouteSpecHttp2RouteActionRewriteHostnameArgs =
        GatewayRouteSpecHttp2RouteActionRewriteHostnameArgs(
            defaultTargetHostname = defaultTargetHostname ?: throw
                PulumiNullFieldException("defaultTargetHostname"),
        )
}
