@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionTargetVirtualServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property virtualServiceName Name of the virtual service that traffic is routed to. Must be between 1 and 255 characters in length.
 */
public data class GatewayRouteSpecHttp2RouteActionTargetVirtualServiceArgs(
    public val virtualServiceName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionTargetVirtualServiceArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionTargetVirtualServiceArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionTargetVirtualServiceArgs.builder()
            .virtualServiceName(virtualServiceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteSpecHttp2RouteActionTargetVirtualServiceArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttp2RouteActionTargetVirtualServiceArgsBuilder internal constructor() {
    private var virtualServiceName: Output<String>? = null

    /**
     * @param value Name of the virtual service that traffic is routed to. Must be between 1 and 255 characters in length.
     */
    @JvmName("ijxwdopsjbgtvnvr")
    public suspend fun virtualServiceName(`value`: Output<String>) {
        this.virtualServiceName = value
    }

    /**
     * @param value Name of the virtual service that traffic is routed to. Must be between 1 and 255 characters in length.
     */
    @JvmName("wnkmekwexdpmubjm")
    public suspend fun virtualServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualServiceName = mapped
    }

    internal fun build(): GatewayRouteSpecHttp2RouteActionTargetVirtualServiceArgs =
        GatewayRouteSpecHttp2RouteActionTargetVirtualServiceArgs(
            virtualServiceName = virtualServiceName ?: throw PulumiNullFieldException("virtualServiceName"),
        )
}
