@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property rewrite Gateway route action to rewrite.
 * @property target Target that traffic is routed to when a request matches the gateway route.
 */
public data class GatewayRouteSpecHttpRouteActionArgs(
    public val rewrite: Output<GatewayRouteSpecHttpRouteActionRewriteArgs>? = null,
    public val target: Output<GatewayRouteSpecHttpRouteActionTargetArgs>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionArgs.builder()
            .rewrite(rewrite?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .target(target.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GatewayRouteSpecHttpRouteActionArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttpRouteActionArgsBuilder internal constructor() {
    private var rewrite: Output<GatewayRouteSpecHttpRouteActionRewriteArgs>? = null

    private var target: Output<GatewayRouteSpecHttpRouteActionTargetArgs>? = null

    /**
     * @param value Gateway route action to rewrite.
     */
    @JvmName("gpxjgimocuuxskpv")
    public suspend fun rewrite(`value`: Output<GatewayRouteSpecHttpRouteActionRewriteArgs>) {
        this.rewrite = value
    }

    /**
     * @param value Target that traffic is routed to when a request matches the gateway route.
     */
    @JvmName("ljumnvttxpgwosaf")
    public suspend fun target(`value`: Output<GatewayRouteSpecHttpRouteActionTargetArgs>) {
        this.target = value
    }

    /**
     * @param value Gateway route action to rewrite.
     */
    @JvmName("crjacxjmdjyxpayu")
    public suspend fun rewrite(`value`: GatewayRouteSpecHttpRouteActionRewriteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rewrite = mapped
    }

    /**
     * @param argument Gateway route action to rewrite.
     */
    @JvmName("asnaiicdnygofvyl")
    public suspend fun rewrite(argument: suspend GatewayRouteSpecHttpRouteActionRewriteArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttpRouteActionRewriteArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rewrite = mapped
    }

    /**
     * @param value Target that traffic is routed to when a request matches the gateway route.
     */
    @JvmName("emvknsnlhwdjpvfv")
    public suspend fun target(`value`: GatewayRouteSpecHttpRouteActionTargetArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param argument Target that traffic is routed to when a request matches the gateway route.
     */
    @JvmName("sffljxfneshxyfow")
    public suspend fun target(argument: suspend GatewayRouteSpecHttpRouteActionTargetArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttpRouteActionTargetArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.target = mapped
    }

    internal fun build(): GatewayRouteSpecHttpRouteActionArgs = GatewayRouteSpecHttpRouteActionArgs(
        rewrite = rewrite,
        target = target ?: throw PulumiNullFieldException("target"),
    )
}
