@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionRewriteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property hostname Host name to rewrite.
 * @property path Exact path to rewrite.
 * @property prefix Specified beginning characters to rewrite.
 */
public data class GatewayRouteSpecHttpRouteActionRewriteArgs(
    public val hostname: Output<GatewayRouteSpecHttpRouteActionRewriteHostnameArgs>? = null,
    public val path: Output<GatewayRouteSpecHttpRouteActionRewritePathArgs>? = null,
    public val prefix: Output<GatewayRouteSpecHttpRouteActionRewritePrefixArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionRewriteArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionRewriteArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionRewriteArgs.builder()
            .hostname(hostname?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .path(path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .prefix(prefix?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GatewayRouteSpecHttpRouteActionRewriteArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttpRouteActionRewriteArgsBuilder internal constructor() {
    private var hostname: Output<GatewayRouteSpecHttpRouteActionRewriteHostnameArgs>? = null

    private var path: Output<GatewayRouteSpecHttpRouteActionRewritePathArgs>? = null

    private var prefix: Output<GatewayRouteSpecHttpRouteActionRewritePrefixArgs>? = null

    /**
     * @param value Host name to rewrite.
     */
    @JvmName("qefjpbgumosfgbcn")
    public suspend fun hostname(`value`: Output<GatewayRouteSpecHttpRouteActionRewriteHostnameArgs>) {
        this.hostname = value
    }

    /**
     * @param value Exact path to rewrite.
     */
    @JvmName("gttiktvkrodpvjbl")
    public suspend fun path(`value`: Output<GatewayRouteSpecHttpRouteActionRewritePathArgs>) {
        this.path = value
    }

    /**
     * @param value Specified beginning characters to rewrite.
     */
    @JvmName("yxhdmnlttcqyrbwr")
    public suspend fun prefix(`value`: Output<GatewayRouteSpecHttpRouteActionRewritePrefixArgs>) {
        this.prefix = value
    }

    /**
     * @param value Host name to rewrite.
     */
    @JvmName("hkcgbhnceurbvolx")
    public suspend fun hostname(`value`: GatewayRouteSpecHttpRouteActionRewriteHostnameArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostname = mapped
    }

    /**
     * @param argument Host name to rewrite.
     */
    @JvmName("yyvkkrftcmjjayuw")
    public suspend fun hostname(argument: suspend GatewayRouteSpecHttpRouteActionRewriteHostnameArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttpRouteActionRewriteHostnameArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.hostname = mapped
    }

    /**
     * @param value Exact path to rewrite.
     */
    @JvmName("ssrgndkkhpddyufj")
    public suspend fun path(`value`: GatewayRouteSpecHttpRouteActionRewritePathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param argument Exact path to rewrite.
     */
    @JvmName("krbnkutnlnsqrqof")
    public suspend fun path(argument: suspend GatewayRouteSpecHttpRouteActionRewritePathArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttpRouteActionRewritePathArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.path = mapped
    }

    /**
     * @param value Specified beginning characters to rewrite.
     */
    @JvmName("fthfjddrdgkxkigc")
    public suspend fun prefix(`value`: GatewayRouteSpecHttpRouteActionRewritePrefixArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param argument Specified beginning characters to rewrite.
     */
    @JvmName("fkucbhvjvcrsslwn")
    public suspend fun prefix(argument: suspend GatewayRouteSpecHttpRouteActionRewritePrefixArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttpRouteActionRewritePrefixArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.prefix = mapped
    }

    internal fun build(): GatewayRouteSpecHttpRouteActionRewriteArgs =
        GatewayRouteSpecHttpRouteActionRewriteArgs(
            hostname = hostname,
            path = path,
            prefix = prefix,
        )
}
