@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property port The port number that corresponds to the target for Virtual Service provider port. This is required when the provider (router or node) of the Virtual Service has multiple listeners.
 * @property virtualService Virtual service gateway route target.
 */
public data class GatewayRouteSpecHttpRouteActionTargetArgs(
    public val port: Output<Int>? = null,
    public val virtualService: Output<GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionTargetArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionTargetArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionTargetArgs.builder()
            .port(port?.applyValue({ args0 -> args0 }))
            .virtualService(
                virtualService.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [GatewayRouteSpecHttpRouteActionTargetArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttpRouteActionTargetArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var virtualService: Output<GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs>? =
        null

    /**
     * @param value The port number that corresponds to the target for Virtual Service provider port. This is required when the provider (router or node) of the Virtual Service has multiple listeners.
     */
    @JvmName("etekremwsdtgouwl")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Virtual service gateway route target.
     */
    @JvmName("aydfjcoestrarmem")
    public suspend fun virtualService(`value`: Output<GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs>) {
        this.virtualService = value
    }

    /**
     * @param value The port number that corresponds to the target for Virtual Service provider port. This is required when the provider (router or node) of the Virtual Service has multiple listeners.
     */
    @JvmName("kjvpcwmbpldlhujc")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Virtual service gateway route target.
     */
    @JvmName("xiwvvcoghfpmjkpj")
    public suspend fun virtualService(`value`: GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualService = mapped
    }

    /**
     * @param argument Virtual service gateway route target.
     */
    @JvmName("hhysuiefjfldfsrj")
    public suspend fun virtualService(argument: suspend GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.virtualService = mapped
    }

    internal fun build(): GatewayRouteSpecHttpRouteActionTargetArgs =
        GatewayRouteSpecHttpRouteActionTargetArgs(
            port = port,
            virtualService = virtualService ?: throw PulumiNullFieldException("virtualService"),
        )
}
