@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property headers Client request headers to match on.
 * @property hostname Host name to match on.
 * @property path Client request path to match on.
 * @property port The port number to match from the request.
 * @property prefix Path to match requests with. This parameter must always start with `/`, which by itself matches all requests to the virtual service name.
 * @property queryParameters Client request query parameters to match on.
 */
public data class GatewayRouteSpecHttpRouteMatchArgs(
    public val headers: Output<List<GatewayRouteSpecHttpRouteMatchHeaderArgs>>? = null,
    public val hostname: Output<GatewayRouteSpecHttpRouteMatchHostnameArgs>? = null,
    public val path: Output<GatewayRouteSpecHttpRouteMatchPathArgs>? = null,
    public val port: Output<Int>? = null,
    public val prefix: Output<String>? = null,
    public val queryParameters: Output<List<GatewayRouteSpecHttpRouteMatchQueryParameterArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchArgs.builder()
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .hostname(hostname?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .path(path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .port(port?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .queryParameters(
                queryParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GatewayRouteSpecHttpRouteMatchArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttpRouteMatchArgsBuilder internal constructor() {
    private var headers: Output<List<GatewayRouteSpecHttpRouteMatchHeaderArgs>>? = null

    private var hostname: Output<GatewayRouteSpecHttpRouteMatchHostnameArgs>? = null

    private var path: Output<GatewayRouteSpecHttpRouteMatchPathArgs>? = null

    private var port: Output<Int>? = null

    private var prefix: Output<String>? = null

    private var queryParameters: Output<List<GatewayRouteSpecHttpRouteMatchQueryParameterArgs>>? =
        null

    /**
     * @param value Client request headers to match on.
     */
    @JvmName("rtkoqkwegrvcgdfl")
    public suspend fun headers(`value`: Output<List<GatewayRouteSpecHttpRouteMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("hnseumcdhpfrtord")
    public suspend fun headers(vararg values: Output<GatewayRouteSpecHttpRouteMatchHeaderArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Client request headers to match on.
     */
    @JvmName("vmviipdlxdeeqmrs")
    public suspend fun headers(values: List<Output<GatewayRouteSpecHttpRouteMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Host name to match on.
     */
    @JvmName("atbgjslijnsxqlkh")
    public suspend fun hostname(`value`: Output<GatewayRouteSpecHttpRouteMatchHostnameArgs>) {
        this.hostname = value
    }

    /**
     * @param value Client request path to match on.
     */
    @JvmName("rtbpxysigsxrvopu")
    public suspend fun path(`value`: Output<GatewayRouteSpecHttpRouteMatchPathArgs>) {
        this.path = value
    }

    /**
     * @param value The port number to match from the request.
     */
    @JvmName("gkwyddpgvmcuybcr")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Path to match requests with. This parameter must always start with `/`, which by itself matches all requests to the virtual service name.
     */
    @JvmName("asppyrkvehnrgkth")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Client request query parameters to match on.
     */
    @JvmName("wgdhblqrewxgjbtv")
    public suspend fun queryParameters(`value`: Output<List<GatewayRouteSpecHttpRouteMatchQueryParameterArgs>>) {
        this.queryParameters = value
    }

    @JvmName("bdbqcvxoogiqwdin")
    public suspend fun queryParameters(vararg values: Output<GatewayRouteSpecHttpRouteMatchQueryParameterArgs>) {
        this.queryParameters = Output.all(values.asList())
    }

    /**
     * @param values Client request query parameters to match on.
     */
    @JvmName("hwxemcyugsbwhgfs")
    public suspend fun queryParameters(values: List<Output<GatewayRouteSpecHttpRouteMatchQueryParameterArgs>>) {
        this.queryParameters = Output.all(values)
    }

    /**
     * @param value Client request headers to match on.
     */
    @JvmName("measjhppgfdjytoa")
    public suspend fun headers(`value`: List<GatewayRouteSpecHttpRouteMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Client request headers to match on.
     */
    @JvmName("fjwcgdthwowrtpjm")
    public suspend fun headers(argument: List<suspend GatewayRouteSpecHttpRouteMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GatewayRouteSpecHttpRouteMatchHeaderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Client request headers to match on.
     */
    @JvmName("ktlnccojcuclopsm")
    public suspend fun headers(vararg argument: suspend GatewayRouteSpecHttpRouteMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GatewayRouteSpecHttpRouteMatchHeaderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Client request headers to match on.
     */
    @JvmName("owtyfxpxbqluyhtf")
    public suspend fun headers(argument: suspend GatewayRouteSpecHttpRouteMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GatewayRouteSpecHttpRouteMatchHeaderArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Client request headers to match on.
     */
    @JvmName("xqejaqgtvnvcinmi")
    public suspend fun headers(vararg values: GatewayRouteSpecHttpRouteMatchHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Host name to match on.
     */
    @JvmName("jwmcdasrkwbwymij")
    public suspend fun hostname(`value`: GatewayRouteSpecHttpRouteMatchHostnameArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostname = mapped
    }

    /**
     * @param argument Host name to match on.
     */
    @JvmName("doptjolajjumyfpp")
    public suspend fun hostname(argument: suspend GatewayRouteSpecHttpRouteMatchHostnameArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttpRouteMatchHostnameArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.hostname = mapped
    }

    /**
     * @param value Client request path to match on.
     */
    @JvmName("bqoqltelsviwqmnv")
    public suspend fun path(`value`: GatewayRouteSpecHttpRouteMatchPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param argument Client request path to match on.
     */
    @JvmName("xxnjgvoysecfcwka")
    public suspend fun path(argument: suspend GatewayRouteSpecHttpRouteMatchPathArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttpRouteMatchPathArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.path = mapped
    }

    /**
     * @param value The port number to match from the request.
     */
    @JvmName("xemjojrkymayyysi")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Path to match requests with. This parameter must always start with `/`, which by itself matches all requests to the virtual service name.
     */
    @JvmName("bxweyaenbjqpnjki")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Client request query parameters to match on.
     */
    @JvmName("wfjntfabprrdykbu")
    public suspend fun queryParameters(`value`: List<GatewayRouteSpecHttpRouteMatchQueryParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryParameters = mapped
    }

    /**
     * @param argument Client request query parameters to match on.
     */
    @JvmName("lceiidrnigtyknar")
    public suspend fun queryParameters(argument: List<suspend GatewayRouteSpecHttpRouteMatchQueryParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GatewayRouteSpecHttpRouteMatchQueryParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.queryParameters = mapped
    }

    /**
     * @param argument Client request query parameters to match on.
     */
    @JvmName("lxernegvvmdyggxs")
    public suspend fun queryParameters(vararg argument: suspend GatewayRouteSpecHttpRouteMatchQueryParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GatewayRouteSpecHttpRouteMatchQueryParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.queryParameters = mapped
    }

    /**
     * @param argument Client request query parameters to match on.
     */
    @JvmName("ioddninknigtttom")
    public suspend fun queryParameters(argument: suspend GatewayRouteSpecHttpRouteMatchQueryParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GatewayRouteSpecHttpRouteMatchQueryParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.queryParameters = mapped
    }

    /**
     * @param values Client request query parameters to match on.
     */
    @JvmName("njhfyitwdbvspjml")
    public suspend fun queryParameters(vararg values: GatewayRouteSpecHttpRouteMatchQueryParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryParameters = mapped
    }

    internal fun build(): GatewayRouteSpecHttpRouteMatchArgs = GatewayRouteSpecHttpRouteMatchArgs(
        headers = headers,
        hostname = hostname,
        path = path,
        port = port,
        prefix = prefix,
        queryParameters = queryParameters,
    )
}
