@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchHostnameArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property exact Exact host name to match on.
 * @property suffix Specified ending characters of the host name to match on.
 */
public data class GatewayRouteSpecHttpRouteMatchHostnameArgs(
    public val exact: Output<String>? = null,
    public val suffix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchHostnameArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchHostnameArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchHostnameArgs.builder()
            .exact(exact?.applyValue({ args0 -> args0 }))
            .suffix(suffix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteSpecHttpRouteMatchHostnameArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttpRouteMatchHostnameArgsBuilder internal constructor() {
    private var exact: Output<String>? = null

    private var suffix: Output<String>? = null

    /**
     * @param value Exact host name to match on.
     */
    @JvmName("vmvhpcupcpffakyv")
    public suspend fun exact(`value`: Output<String>) {
        this.exact = value
    }

    /**
     * @param value Specified ending characters of the host name to match on.
     */
    @JvmName("rofuormhkylwmgvi")
    public suspend fun suffix(`value`: Output<String>) {
        this.suffix = value
    }

    /**
     * @param value Exact host name to match on.
     */
    @JvmName("qtibvdnyritapaxm")
    public suspend fun exact(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exact = mapped
    }

    /**
     * @param value Specified ending characters of the host name to match on.
     */
    @JvmName("cpoaxjuomkjdrrmj")
    public suspend fun suffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suffix = mapped
    }

    internal fun build(): GatewayRouteSpecHttpRouteMatchHostnameArgs =
        GatewayRouteSpecHttpRouteMatchHostnameArgs(
            exact = exact,
            suffix = suffix,
        )
}
