@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchQueryParameterMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property exact The exact query parameter to match on.
 */
public data class GatewayRouteSpecHttpRouteMatchQueryParameterMatchArgs(
    public val exact: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchQueryParameterMatchArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchQueryParameterMatchArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchQueryParameterMatchArgs.builder()
            .exact(exact?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteSpecHttpRouteMatchQueryParameterMatchArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttpRouteMatchQueryParameterMatchArgsBuilder internal constructor() {
    private var exact: Output<String>? = null

    /**
     * @param value The exact query parameter to match on.
     */
    @JvmName("rcfjymovxrkhmjlo")
    public suspend fun exact(`value`: Output<String>) {
        this.exact = value
    }

    /**
     * @param value The exact query parameter to match on.
     */
    @JvmName("xahiipamxynnejro")
    public suspend fun exact(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exact = mapped
    }

    internal fun build(): GatewayRouteSpecHttpRouteMatchQueryParameterMatchArgs =
        GatewayRouteSpecHttpRouteMatchQueryParameterMatchArgs(
            exact = exact,
        )
}
