@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GetVirtualNodePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVirtualNode.
 * @property meshName Name of the service mesh in which the virtual node exists.
 * @property meshOwner AWS account ID of the service mesh's owner.
 * @property name Name of the virtual node.
 * @property tags Map of tags.
 */
public data class GetVirtualNodePlainArgs(
    public val meshName: String,
    public val meshOwner: String? = null,
    public val name: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GetVirtualNodePlainArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GetVirtualNodePlainArgs =
        com.pulumi.aws.appmesh.inputs.GetVirtualNodePlainArgs.builder()
            .meshName(meshName.let({ args0 -> args0 }))
            .meshOwner(meshOwner?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetVirtualNodePlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNodePlainArgsBuilder internal constructor() {
    private var meshName: String? = null

    private var meshOwner: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the service mesh in which the virtual node exists.
     */
    @JvmName("urhwxijmvsourfjf")
    public suspend fun meshName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.meshName = mapped
    }

    /**
     * @param value AWS account ID of the service mesh's owner.
     */
    @JvmName("ktroqquntnsjqghl")
    public suspend fun meshOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.meshOwner = mapped
    }

    /**
     * @param value Name of the virtual node.
     */
    @JvmName("ndywmjsrvfnudsrs")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of tags.
     */
    @JvmName("doiqbrgxtfmmuwdx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags.
     */
    @JvmName("hmadmusopiguorft")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetVirtualNodePlainArgs = GetVirtualNodePlainArgs(
        meshName = meshName ?: throw PulumiNullFieldException("meshName"),
        meshOwner = meshOwner,
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
    )
}
