@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.MeshSpecEgressFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type Egress filter type. By default, the type is `DROP_ALL`. Valid values are `ALLOW_ALL` and `DROP_ALL`.
 */
public data class MeshSpecEgressFilterArgs(
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.MeshSpecEgressFilterArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.MeshSpecEgressFilterArgs =
        com.pulumi.aws.appmesh.inputs.MeshSpecEgressFilterArgs.builder()
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MeshSpecEgressFilterArgs].
 */
@PulumiTagMarker
public class MeshSpecEgressFilterArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value Egress filter type. By default, the type is `DROP_ALL`. Valid values are `ALLOW_ALL` and `DROP_ALL`.
     */
    @JvmName("cjqlqonvrakhmler")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Egress filter type. By default, the type is `DROP_ALL`. Valid values are `ALLOW_ALL` and `DROP_ALL`.
     */
    @JvmName("pyoubharpjndeqpm")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): MeshSpecEgressFilterArgs = MeshSpecEgressFilterArgs(
        type = type,
    )
}
