@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.MeshSpecServiceDiscoveryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipPreference The IP version to use to control traffic within the mesh. Valid values are `IPv6_PREFERRED`, `IPv4_PREFERRED`, `IPv4_ONLY`, and `IPv6_ONLY`.
 */
public data class MeshSpecServiceDiscoveryArgs(
    public val ipPreference: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.MeshSpecServiceDiscoveryArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.MeshSpecServiceDiscoveryArgs =
        com.pulumi.aws.appmesh.inputs.MeshSpecServiceDiscoveryArgs.builder()
            .ipPreference(ipPreference?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MeshSpecServiceDiscoveryArgs].
 */
@PulumiTagMarker
public class MeshSpecServiceDiscoveryArgsBuilder internal constructor() {
    private var ipPreference: Output<String>? = null

    /**
     * @param value The IP version to use to control traffic within the mesh. Valid values are `IPv6_PREFERRED`, `IPv4_PREFERRED`, `IPv4_ONLY`, and `IPv6_ONLY`.
     */
    @JvmName("xngpjkssiqnfahwm")
    public suspend fun ipPreference(`value`: Output<String>) {
        this.ipPreference = value
    }

    /**
     * @param value The IP version to use to control traffic within the mesh. Valid values are `IPv6_PREFERRED`, `IPv4_PREFERRED`, `IPv4_ONLY`, and `IPv6_ONLY`.
     */
    @JvmName("yqxlkwosiergytcb")
    public suspend fun ipPreference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipPreference = mapped
    }

    internal fun build(): MeshSpecServiceDiscoveryArgs = MeshSpecServiceDiscoveryArgs(
        ipPreference = ipPreference,
    )
}
