@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property grpcRoute GRPC routing information for the route.
 * @property http2Route HTTP/2 routing information for the route.
 * @property httpRoute HTTP routing information for the route.
 * @property priority Priority for the route, between `0` and `1000`.
 * Routes are matched based on the specified value, where `0` is the highest priority.
 * @property tcpRoute TCP routing information for the route.
 */
public data class RouteSpecArgs(
    public val grpcRoute: Output<RouteSpecGrpcRouteArgs>? = null,
    public val http2Route: Output<RouteSpecHttp2RouteArgs>? = null,
    public val httpRoute: Output<RouteSpecHttpRouteArgs>? = null,
    public val priority: Output<Int>? = null,
    public val tcpRoute: Output<RouteSpecTcpRouteArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecArgs.builder()
            .grpcRoute(grpcRoute?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .http2Route(http2Route?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpRoute(httpRoute?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .tcpRoute(tcpRoute?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RouteSpecArgs].
 */
@PulumiTagMarker
public class RouteSpecArgsBuilder internal constructor() {
    private var grpcRoute: Output<RouteSpecGrpcRouteArgs>? = null

    private var http2Route: Output<RouteSpecHttp2RouteArgs>? = null

    private var httpRoute: Output<RouteSpecHttpRouteArgs>? = null

    private var priority: Output<Int>? = null

    private var tcpRoute: Output<RouteSpecTcpRouteArgs>? = null

    /**
     * @param value GRPC routing information for the route.
     */
    @JvmName("rcpwmhgkwanufkhw")
    public suspend fun grpcRoute(`value`: Output<RouteSpecGrpcRouteArgs>) {
        this.grpcRoute = value
    }

    /**
     * @param value HTTP/2 routing information for the route.
     */
    @JvmName("usjssunoboryapow")
    public suspend fun http2Route(`value`: Output<RouteSpecHttp2RouteArgs>) {
        this.http2Route = value
    }

    /**
     * @param value HTTP routing information for the route.
     */
    @JvmName("mgqqysgbqhimnqyy")
    public suspend fun httpRoute(`value`: Output<RouteSpecHttpRouteArgs>) {
        this.httpRoute = value
    }

    /**
     * @param value Priority for the route, between `0` and `1000`.
     * Routes are matched based on the specified value, where `0` is the highest priority.
     */
    @JvmName("rqccllcfwxgbtvfx")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value TCP routing information for the route.
     */
    @JvmName("yepchiaiwhvvwkxe")
    public suspend fun tcpRoute(`value`: Output<RouteSpecTcpRouteArgs>) {
        this.tcpRoute = value
    }

    /**
     * @param value GRPC routing information for the route.
     */
    @JvmName("tdkhgacubfpyaswh")
    public suspend fun grpcRoute(`value`: RouteSpecGrpcRouteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grpcRoute = mapped
    }

    /**
     * @param argument GRPC routing information for the route.
     */
    @JvmName("lwxjtclkrdeupywh")
    public suspend fun grpcRoute(argument: suspend RouteSpecGrpcRouteArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecGrpcRouteArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.grpcRoute = mapped
    }

    /**
     * @param value HTTP/2 routing information for the route.
     */
    @JvmName("adgqexhkatrwqsix")
    public suspend fun http2Route(`value`: RouteSpecHttp2RouteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http2Route = mapped
    }

    /**
     * @param argument HTTP/2 routing information for the route.
     */
    @JvmName("rbymggupxuxlqwpp")
    public suspend fun http2Route(argument: suspend RouteSpecHttp2RouteArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttp2RouteArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.http2Route = mapped
    }

    /**
     * @param value HTTP routing information for the route.
     */
    @JvmName("aocmtrxfggfspnqb")
    public suspend fun httpRoute(`value`: RouteSpecHttpRouteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpRoute = mapped
    }

    /**
     * @param argument HTTP routing information for the route.
     */
    @JvmName("htvehibmtqltuonl")
    public suspend fun httpRoute(argument: suspend RouteSpecHttpRouteArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttpRouteArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpRoute = mapped
    }

    /**
     * @param value Priority for the route, between `0` and `1000`.
     * Routes are matched based on the specified value, where `0` is the highest priority.
     */
    @JvmName("rurtgttbuqqhgssc")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value TCP routing information for the route.
     */
    @JvmName("teohynmvomorbery")
    public suspend fun tcpRoute(`value`: RouteSpecTcpRouteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpRoute = mapped
    }

    /**
     * @param argument TCP routing information for the route.
     */
    @JvmName("radreubopscupcfq")
    public suspend fun tcpRoute(argument: suspend RouteSpecTcpRouteArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecTcpRouteArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tcpRoute = mapped
    }

    internal fun build(): RouteSpecArgs = RouteSpecArgs(
        grpcRoute = grpcRoute,
        http2Route = http2Route,
        httpRoute = httpRoute,
        priority = priority,
        tcpRoute = tcpRoute,
    )
}
