@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteActionWeightedTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property port The targeted port of the weighted object.
 * @property virtualNode Virtual node to associate with the weighted target. Must be between 1 and 255 characters in length.
 * @property weight Relative weight of the weighted target. An integer between 0 and 100.
 */
public data class RouteSpecGrpcRouteActionWeightedTargetArgs(
    public val port: Output<Int>? = null,
    public val virtualNode: Output<String>,
    public val weight: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteActionWeightedTargetArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteActionWeightedTargetArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteActionWeightedTargetArgs.builder()
            .port(port?.applyValue({ args0 -> args0 }))
            .virtualNode(virtualNode.applyValue({ args0 -> args0 }))
            .weight(weight.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecGrpcRouteActionWeightedTargetArgs].
 */
@PulumiTagMarker
public class RouteSpecGrpcRouteActionWeightedTargetArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var virtualNode: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The targeted port of the weighted object.
     */
    @JvmName("tqwoeswbagiwsruy")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Virtual node to associate with the weighted target. Must be between 1 and 255 characters in length.
     */
    @JvmName("xxplxsdyfvnvkvku")
    public suspend fun virtualNode(`value`: Output<String>) {
        this.virtualNode = value
    }

    /**
     * @param value Relative weight of the weighted target. An integer between 0 and 100.
     */
    @JvmName("rpoumssxpfolpjlq")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The targeted port of the weighted object.
     */
    @JvmName("bufyvmgvqlikhreu")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Virtual node to associate with the weighted target. Must be between 1 and 255 characters in length.
     */
    @JvmName("ildrqopbbabystjo")
    public suspend fun virtualNode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNode = mapped
    }

    /**
     * @param value Relative weight of the weighted target. An integer between 0 and 100.
     */
    @JvmName("hctglohnyasqgocg")
    public suspend fun weight(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): RouteSpecGrpcRouteActionWeightedTargetArgs =
        RouteSpecGrpcRouteActionWeightedTargetArgs(
            port = port,
            virtualNode = virtualNode ?: throw PulumiNullFieldException("virtualNode"),
            weight = weight ?: throw PulumiNullFieldException("weight"),
        )
}
