@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property action Action to take if a match is determined.
 * @property match Criteria for determining an gRPC request match.
 * @property retryPolicy Retry policy.
 * @property timeout Types of timeouts.
 */
public data class RouteSpecGrpcRouteArgs(
    public val action: Output<RouteSpecGrpcRouteActionArgs>,
    public val match: Output<RouteSpecGrpcRouteMatchArgs>? = null,
    public val retryPolicy: Output<RouteSpecGrpcRouteRetryPolicyArgs>? = null,
    public val timeout: Output<RouteSpecGrpcRouteTimeoutArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteArgs.builder()
            .action(action.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .match(match?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retryPolicy(retryPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeout(timeout?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RouteSpecGrpcRouteArgs].
 */
@PulumiTagMarker
public class RouteSpecGrpcRouteArgsBuilder internal constructor() {
    private var action: Output<RouteSpecGrpcRouteActionArgs>? = null

    private var match: Output<RouteSpecGrpcRouteMatchArgs>? = null

    private var retryPolicy: Output<RouteSpecGrpcRouteRetryPolicyArgs>? = null

    private var timeout: Output<RouteSpecGrpcRouteTimeoutArgs>? = null

    /**
     * @param value Action to take if a match is determined.
     */
    @JvmName("gtentnntkroqnnlj")
    public suspend fun action(`value`: Output<RouteSpecGrpcRouteActionArgs>) {
        this.action = value
    }

    /**
     * @param value Criteria for determining an gRPC request match.
     */
    @JvmName("uknejcnjtusuioov")
    public suspend fun match(`value`: Output<RouteSpecGrpcRouteMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Retry policy.
     */
    @JvmName("idplmwdudopoyjld")
    public suspend fun retryPolicy(`value`: Output<RouteSpecGrpcRouteRetryPolicyArgs>) {
        this.retryPolicy = value
    }

    /**
     * @param value Types of timeouts.
     */
    @JvmName("rnmlgfrskucmxkph")
    public suspend fun timeout(`value`: Output<RouteSpecGrpcRouteTimeoutArgs>) {
        this.timeout = value
    }

    /**
     * @param value Action to take if a match is determined.
     */
    @JvmName("ohfbxrckynfpptdi")
    public suspend fun action(`value`: RouteSpecGrpcRouteActionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument Action to take if a match is determined.
     */
    @JvmName("xuprijwbmnhnhvtw")
    public suspend fun action(argument: suspend RouteSpecGrpcRouteActionArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecGrpcRouteActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Criteria for determining an gRPC request match.
     */
    @JvmName("epqpkbqwwnxpbfku")
    public suspend fun match(`value`: RouteSpecGrpcRouteMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument Criteria for determining an gRPC request match.
     */
    @JvmName("fmtfjaplqivvhuit")
    public suspend fun match(argument: suspend RouteSpecGrpcRouteMatchArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecGrpcRouteMatchArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value Retry policy.
     */
    @JvmName("ktwsnuwduqufbags")
    public suspend fun retryPolicy(`value`: RouteSpecGrpcRouteRetryPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryPolicy = mapped
    }

    /**
     * @param argument Retry policy.
     */
    @JvmName("ibdidwflunkomijg")
    public suspend fun retryPolicy(argument: suspend RouteSpecGrpcRouteRetryPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecGrpcRouteRetryPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retryPolicy = mapped
    }

    /**
     * @param value Types of timeouts.
     */
    @JvmName("raaplohnhukhcyaq")
    public suspend fun timeout(`value`: RouteSpecGrpcRouteTimeoutArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param argument Types of timeouts.
     */
    @JvmName("tpoqiyrheebrytrg")
    public suspend fun timeout(argument: suspend RouteSpecGrpcRouteTimeoutArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecGrpcRouteTimeoutArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeout = mapped
    }

    internal fun build(): RouteSpecGrpcRouteArgs = RouteSpecGrpcRouteArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        match = match,
        retryPolicy = retryPolicy,
        timeout = timeout,
    )
}
