@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property metadatas Data to match from the gRPC request.
 * @property methodName Method name to match from the request. If you specify a name, you must also specify a `service_name`.
 * @property port The port number to match from the request.
 * @property prefix
 * @property serviceName Fully qualified domain name for the service to match from the request.
 */
public data class RouteSpecGrpcRouteMatchArgs(
    public val metadatas: Output<List<RouteSpecGrpcRouteMatchMetadataArgs>>? = null,
    public val methodName: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val prefix: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteMatchArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteMatchArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteMatchArgs.builder()
            .metadatas(
                metadatas?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .methodName(methodName?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecGrpcRouteMatchArgs].
 */
@PulumiTagMarker
public class RouteSpecGrpcRouteMatchArgsBuilder internal constructor() {
    private var metadatas: Output<List<RouteSpecGrpcRouteMatchMetadataArgs>>? = null

    private var methodName: Output<String>? = null

    private var port: Output<Int>? = null

    private var prefix: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Data to match from the gRPC request.
     */
    @JvmName("udkxjegbkxbupmgi")
    public suspend fun metadatas(`value`: Output<List<RouteSpecGrpcRouteMatchMetadataArgs>>) {
        this.metadatas = value
    }

    @JvmName("tsyiqmyfjxgmglxi")
    public suspend fun metadatas(vararg values: Output<RouteSpecGrpcRouteMatchMetadataArgs>) {
        this.metadatas = Output.all(values.asList())
    }

    /**
     * @param values Data to match from the gRPC request.
     */
    @JvmName("ovonrycvjpfmxyan")
    public suspend fun metadatas(values: List<Output<RouteSpecGrpcRouteMatchMetadataArgs>>) {
        this.metadatas = Output.all(values)
    }

    /**
     * @param value Method name to match from the request. If you specify a name, you must also specify a `service_name`.
     */
    @JvmName("xhqyaivgmlerbdad")
    public suspend fun methodName(`value`: Output<String>) {
        this.methodName = value
    }

    /**
     * @param value The port number to match from the request.
     */
    @JvmName("lgxgsvntxfdghnyd")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value
     */
    @JvmName("hrjkkxnheiywallb")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Fully qualified domain name for the service to match from the request.
     */
    @JvmName("lnbqsdvdjnxoascf")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Data to match from the gRPC request.
     */
    @JvmName("lypgwnwtbaqymlbn")
    public suspend fun metadatas(`value`: List<RouteSpecGrpcRouteMatchMetadataArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadatas = mapped
    }

    /**
     * @param argument Data to match from the gRPC request.
     */
    @JvmName("mpcsgvjamcoxtncc")
    public suspend fun metadatas(argument: List<suspend RouteSpecGrpcRouteMatchMetadataArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RouteSpecGrpcRouteMatchMetadataArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadatas = mapped
    }

    /**
     * @param argument Data to match from the gRPC request.
     */
    @JvmName("axkkjshhyphspbfy")
    public suspend fun metadatas(vararg argument: suspend RouteSpecGrpcRouteMatchMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RouteSpecGrpcRouteMatchMetadataArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadatas = mapped
    }

    /**
     * @param argument Data to match from the gRPC request.
     */
    @JvmName("xpcbuobqtolojhjg")
    public suspend fun metadatas(argument: suspend RouteSpecGrpcRouteMatchMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RouteSpecGrpcRouteMatchMetadataArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.metadatas = mapped
    }

    /**
     * @param values Data to match from the gRPC request.
     */
    @JvmName("dhhxhresghsyewuo")
    public suspend fun metadatas(vararg values: RouteSpecGrpcRouteMatchMetadataArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadatas = mapped
    }

    /**
     * @param value Method name to match from the request. If you specify a name, you must also specify a `service_name`.
     */
    @JvmName("lklopmhfjiwuauun")
    public suspend fun methodName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.methodName = mapped
    }

    /**
     * @param value The port number to match from the request.
     */
    @JvmName("ooomknqdhtudlitn")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value
     */
    @JvmName("crblygahenypsdyr")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Fully qualified domain name for the service to match from the request.
     */
    @JvmName("uouojpwlumouxcof")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): RouteSpecGrpcRouteMatchArgs = RouteSpecGrpcRouteMatchArgs(
        metadatas = metadatas,
        methodName = methodName,
        port = port,
        prefix = prefix,
        serviceName = serviceName,
    )
}
