@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteMatchMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property invert If `true`, the match is on the opposite of the `match` criteria. Default is `false`.
 * @property match Data to match from the request.
 * @property name Name of the route. Must be between 1 and 50 characters in length.
 */
public data class RouteSpecGrpcRouteMatchMetadataArgs(
    public val invert: Output<Boolean>? = null,
    public val match: Output<RouteSpecGrpcRouteMatchMetadataMatchArgs>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteMatchMetadataArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteMatchMetadataArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteMatchMetadataArgs.builder()
            .invert(invert?.applyValue({ args0 -> args0 }))
            .match(match?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecGrpcRouteMatchMetadataArgs].
 */
@PulumiTagMarker
public class RouteSpecGrpcRouteMatchMetadataArgsBuilder internal constructor() {
    private var invert: Output<Boolean>? = null

    private var match: Output<RouteSpecGrpcRouteMatchMetadataMatchArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value If `true`, the match is on the opposite of the `match` criteria. Default is `false`.
     */
    @JvmName("ukknjtnfbotwjsen")
    public suspend fun invert(`value`: Output<Boolean>) {
        this.invert = value
    }

    /**
     * @param value Data to match from the request.
     */
    @JvmName("wusjfdaysvltlsaa")
    public suspend fun match(`value`: Output<RouteSpecGrpcRouteMatchMetadataMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Name of the route. Must be between 1 and 50 characters in length.
     */
    @JvmName("qppbmavgutqbgvib")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value If `true`, the match is on the opposite of the `match` criteria. Default is `false`.
     */
    @JvmName("citiiknbirkjcfue")
    public suspend fun invert(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invert = mapped
    }

    /**
     * @param value Data to match from the request.
     */
    @JvmName("mfqxadrygbiywlmr")
    public suspend fun match(`value`: RouteSpecGrpcRouteMatchMetadataMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument Data to match from the request.
     */
    @JvmName("qnermfrpxbolnaue")
    public suspend fun match(argument: suspend RouteSpecGrpcRouteMatchMetadataMatchArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecGrpcRouteMatchMetadataMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value Name of the route. Must be between 1 and 50 characters in length.
     */
    @JvmName("djkwsksegflyueos")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): RouteSpecGrpcRouteMatchMetadataArgs = RouteSpecGrpcRouteMatchMetadataArgs(
        invert = invert,
        match = match,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
