@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteMatchMetadataMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property exact Value sent by the client must match the specified value exactly. Must be between 1 and 255 characters in length.
 * @property prefix Value sent by the client must begin with the specified characters. Must be between 1 and 255 characters in length.
 * @property range Object that specifies the range of numbers that the value sent by the client must be included in.
 * @property regex Value sent by the client must include the specified characters. Must be between 1 and 255 characters in length.
 * @property suffix Value sent by the client must end with the specified characters. Must be between 1 and 255 characters in length.
 */
public data class RouteSpecGrpcRouteMatchMetadataMatchArgs(
    public val exact: Output<String>? = null,
    public val prefix: Output<String>? = null,
    public val range: Output<RouteSpecGrpcRouteMatchMetadataMatchRangeArgs>? = null,
    public val regex: Output<String>? = null,
    public val suffix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteMatchMetadataMatchArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteMatchMetadataMatchArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteMatchMetadataMatchArgs.builder()
            .exact(exact?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .range(range?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .regex(regex?.applyValue({ args0 -> args0 }))
            .suffix(suffix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecGrpcRouteMatchMetadataMatchArgs].
 */
@PulumiTagMarker
public class RouteSpecGrpcRouteMatchMetadataMatchArgsBuilder internal constructor() {
    private var exact: Output<String>? = null

    private var prefix: Output<String>? = null

    private var range: Output<RouteSpecGrpcRouteMatchMetadataMatchRangeArgs>? = null

    private var regex: Output<String>? = null

    private var suffix: Output<String>? = null

    /**
     * @param value Value sent by the client must match the specified value exactly. Must be between 1 and 255 characters in length.
     */
    @JvmName("ffjbtgoedjvrjtkp")
    public suspend fun exact(`value`: Output<String>) {
        this.exact = value
    }

    /**
     * @param value Value sent by the client must begin with the specified characters. Must be between 1 and 255 characters in length.
     */
    @JvmName("rakplelgbgrmgepm")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Object that specifies the range of numbers that the value sent by the client must be included in.
     */
    @JvmName("lkpfhyfctudasbqu")
    public suspend fun range(`value`: Output<RouteSpecGrpcRouteMatchMetadataMatchRangeArgs>) {
        this.range = value
    }

    /**
     * @param value Value sent by the client must include the specified characters. Must be between 1 and 255 characters in length.
     */
    @JvmName("jgbabjgkrfcdgfhu")
    public suspend fun regex(`value`: Output<String>) {
        this.regex = value
    }

    /**
     * @param value Value sent by the client must end with the specified characters. Must be between 1 and 255 characters in length.
     */
    @JvmName("qxrijsedotmmvxcb")
    public suspend fun suffix(`value`: Output<String>) {
        this.suffix = value
    }

    /**
     * @param value Value sent by the client must match the specified value exactly. Must be between 1 and 255 characters in length.
     */
    @JvmName("wsmoksrthxdgjcys")
    public suspend fun exact(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exact = mapped
    }

    /**
     * @param value Value sent by the client must begin with the specified characters. Must be between 1 and 255 characters in length.
     */
    @JvmName("pwwgpqvlvesexccf")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Object that specifies the range of numbers that the value sent by the client must be included in.
     */
    @JvmName("irgrrwrnairbfmsg")
    public suspend fun range(`value`: RouteSpecGrpcRouteMatchMetadataMatchRangeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.range = mapped
    }

    /**
     * @param argument Object that specifies the range of numbers that the value sent by the client must be included in.
     */
    @JvmName("ugxvyemokcfhwphq")
    public suspend fun range(argument: suspend RouteSpecGrpcRouteMatchMetadataMatchRangeArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecGrpcRouteMatchMetadataMatchRangeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.range = mapped
    }

    /**
     * @param value Value sent by the client must include the specified characters. Must be between 1 and 255 characters in length.
     */
    @JvmName("shdpcqjbecwkhgvd")
    public suspend fun regex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regex = mapped
    }

    /**
     * @param value Value sent by the client must end with the specified characters. Must be between 1 and 255 characters in length.
     */
    @JvmName("rxyxgergcwwrcxfi")
    public suspend fun suffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suffix = mapped
    }

    internal fun build(): RouteSpecGrpcRouteMatchMetadataMatchArgs =
        RouteSpecGrpcRouteMatchMetadataMatchArgs(
            exact = exact,
            prefix = prefix,
            range = range,
            regex = regex,
            suffix = suffix,
        )
}
