@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteTimeoutArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property idle Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
 * @property perRequest Per request timeout.
 */
public data class RouteSpecGrpcRouteTimeoutArgs(
    public val idle: Output<RouteSpecGrpcRouteTimeoutIdleArgs>? = null,
    public val perRequest: Output<RouteSpecGrpcRouteTimeoutPerRequestArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteTimeoutArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteTimeoutArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteTimeoutArgs.builder()
            .idle(idle?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .perRequest(perRequest?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RouteSpecGrpcRouteTimeoutArgs].
 */
@PulumiTagMarker
public class RouteSpecGrpcRouteTimeoutArgsBuilder internal constructor() {
    private var idle: Output<RouteSpecGrpcRouteTimeoutIdleArgs>? = null

    private var perRequest: Output<RouteSpecGrpcRouteTimeoutPerRequestArgs>? = null

    /**
     * @param value Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("kogmiiukjttcshac")
    public suspend fun idle(`value`: Output<RouteSpecGrpcRouteTimeoutIdleArgs>) {
        this.idle = value
    }

    /**
     * @param value Per request timeout.
     */
    @JvmName("xqawdkdeqcedkwog")
    public suspend fun perRequest(`value`: Output<RouteSpecGrpcRouteTimeoutPerRequestArgs>) {
        this.perRequest = value
    }

    /**
     * @param value Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("datewyxgkisyutwl")
    public suspend fun idle(`value`: RouteSpecGrpcRouteTimeoutIdleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idle = mapped
    }

    /**
     * @param argument Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("uqrdvcetrcyodfkm")
    public suspend fun idle(argument: suspend RouteSpecGrpcRouteTimeoutIdleArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecGrpcRouteTimeoutIdleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.idle = mapped
    }

    /**
     * @param value Per request timeout.
     */
    @JvmName("hctbmtyikqcmhpli")
    public suspend fun perRequest(`value`: RouteSpecGrpcRouteTimeoutPerRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perRequest = mapped
    }

    /**
     * @param argument Per request timeout.
     */
    @JvmName("ymyfngffkmpkrnuc")
    public suspend fun perRequest(argument: suspend RouteSpecGrpcRouteTimeoutPerRequestArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecGrpcRouteTimeoutPerRequestArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.perRequest = mapped
    }

    internal fun build(): RouteSpecGrpcRouteTimeoutArgs = RouteSpecGrpcRouteTimeoutArgs(
        idle = idle,
        perRequest = perRequest,
    )
}
