@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property weightedTargets Targets that traffic is routed to when a request matches the route.
 * You can specify one or more targets and their relative weights with which to distribute traffic.
 */
public data class RouteSpecHttp2RouteActionArgs(
    public val weightedTargets: Output<List<RouteSpecHttp2RouteActionWeightedTargetArgs>>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteActionArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteActionArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteActionArgs.builder()
            .weightedTargets(
                weightedTargets.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RouteSpecHttp2RouteActionArgs].
 */
@PulumiTagMarker
public class RouteSpecHttp2RouteActionArgsBuilder internal constructor() {
    private var weightedTargets: Output<List<RouteSpecHttp2RouteActionWeightedTargetArgs>>? = null

    /**
     * @param value Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("enudewtutfupddtt")
    public suspend fun weightedTargets(`value`: Output<List<RouteSpecHttp2RouteActionWeightedTargetArgs>>) {
        this.weightedTargets = value
    }

    @JvmName("oduxcibnuojwmggq")
    public suspend fun weightedTargets(vararg values: Output<RouteSpecHttp2RouteActionWeightedTargetArgs>) {
        this.weightedTargets = Output.all(values.asList())
    }

    /**
     * @param values Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("juohxwqfkspwyqkx")
    public suspend fun weightedTargets(values: List<Output<RouteSpecHttp2RouteActionWeightedTargetArgs>>) {
        this.weightedTargets = Output.all(values)
    }

    /**
     * @param value Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("hehvwodgvfjufpsc")
    public suspend fun weightedTargets(`value`: List<RouteSpecHttp2RouteActionWeightedTargetArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weightedTargets = mapped
    }

    /**
     * @param argument Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("nsxdngmlkhuyvqrx")
    public suspend fun weightedTargets(argument: List<suspend RouteSpecHttp2RouteActionWeightedTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RouteSpecHttp2RouteActionWeightedTargetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.weightedTargets = mapped
    }

    /**
     * @param argument Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("nricypnjmxafuyxp")
    public suspend fun weightedTargets(vararg argument: suspend RouteSpecHttp2RouteActionWeightedTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RouteSpecHttp2RouteActionWeightedTargetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.weightedTargets = mapped
    }

    /**
     * @param argument Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("ipbddcbywtmxbdpx")
    public suspend fun weightedTargets(argument: suspend RouteSpecHttp2RouteActionWeightedTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RouteSpecHttp2RouteActionWeightedTargetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.weightedTargets = mapped
    }

    /**
     * @param values Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("qakuhukukpghkocb")
    public suspend fun weightedTargets(vararg values: RouteSpecHttp2RouteActionWeightedTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weightedTargets = mapped
    }

    internal fun build(): RouteSpecHttp2RouteActionArgs = RouteSpecHttp2RouteActionArgs(
        weightedTargets = weightedTargets ?: throw PulumiNullFieldException("weightedTargets"),
    )
}
