@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteTimeoutIdleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property unit Unit of time. Valid values: `ms`, `s`.
 * @property value Number of time units. Minimum value of `0`.
 */
public data class RouteSpecHttp2RouteTimeoutIdleArgs(
    public val unit: Output<String>,
    public val `value`: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteTimeoutIdleArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteTimeoutIdleArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteTimeoutIdleArgs.builder()
            .unit(unit.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecHttp2RouteTimeoutIdleArgs].
 */
@PulumiTagMarker
public class RouteSpecHttp2RouteTimeoutIdleArgsBuilder internal constructor() {
    private var unit: Output<String>? = null

    private var `value`: Output<Int>? = null

    /**
     * @param value Unit of time. Valid values: `ms`, `s`.
     */
    @JvmName("gduodnssdsurkyki")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value Number of time units. Minimum value of `0`.
     */
    @JvmName("pppuepjuebwlxpcl")
    public suspend fun `value`(`value`: Output<Int>) {
        this.`value` = value
    }

    /**
     * @param value Unit of time. Valid values: `ms`, `s`.
     */
    @JvmName("gyijrxpalthmhbvl")
    public suspend fun unit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    /**
     * @param value Number of time units. Minimum value of `0`.
     */
    @JvmName("marhimejcbmevtha")
    public suspend fun `value`(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): RouteSpecHttp2RouteTimeoutIdleArgs = RouteSpecHttp2RouteTimeoutIdleArgs(
        unit = unit ?: throw PulumiNullFieldException("unit"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
