@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchQueryParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property match The query parameter to match on.
 * @property name Name for the query parameter that will be matched on.
 */
public data class RouteSpecHttpRouteMatchQueryParameterArgs(
    public val match: Output<RouteSpecHttpRouteMatchQueryParameterMatchArgs>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchQueryParameterArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchQueryParameterArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchQueryParameterArgs.builder()
            .match(match?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecHttpRouteMatchQueryParameterArgs].
 */
@PulumiTagMarker
public class RouteSpecHttpRouteMatchQueryParameterArgsBuilder internal constructor() {
    private var match: Output<RouteSpecHttpRouteMatchQueryParameterMatchArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value The query parameter to match on.
     */
    @JvmName("bijqnglswauiikrv")
    public suspend fun match(`value`: Output<RouteSpecHttpRouteMatchQueryParameterMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Name for the query parameter that will be matched on.
     */
    @JvmName("jomtcwgsvtyxpggw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The query parameter to match on.
     */
    @JvmName("mujxetbgojplqhgm")
    public suspend fun match(`value`: RouteSpecHttpRouteMatchQueryParameterMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument The query parameter to match on.
     */
    @JvmName("rbeusrkpegxkafpk")
    public suspend fun match(argument: suspend RouteSpecHttpRouteMatchQueryParameterMatchArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttpRouteMatchQueryParameterMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value Name for the query parameter that will be matched on.
     */
    @JvmName("cpwoecpmxjeefbpv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): RouteSpecHttpRouteMatchQueryParameterArgs =
        RouteSpecHttpRouteMatchQueryParameterArgs(
            match = match,
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
