@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteActionWeightedTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property port The targeted port of the weighted object.
 * @property virtualNode Virtual node to associate with the weighted target. Must be between 1 and 255 characters in length.
 * @property weight Relative weight of the weighted target. An integer between 0 and 100.
 */
public data class RouteSpecTcpRouteActionWeightedTargetArgs(
    public val port: Output<Int>? = null,
    public val virtualNode: Output<String>,
    public val weight: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteActionWeightedTargetArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteActionWeightedTargetArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteActionWeightedTargetArgs.builder()
            .port(port?.applyValue({ args0 -> args0 }))
            .virtualNode(virtualNode.applyValue({ args0 -> args0 }))
            .weight(weight.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecTcpRouteActionWeightedTargetArgs].
 */
@PulumiTagMarker
public class RouteSpecTcpRouteActionWeightedTargetArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var virtualNode: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The targeted port of the weighted object.
     */
    @JvmName("bdnfwkvbxxyisjep")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Virtual node to associate with the weighted target. Must be between 1 and 255 characters in length.
     */
    @JvmName("usdbnshpwbbpgmtd")
    public suspend fun virtualNode(`value`: Output<String>) {
        this.virtualNode = value
    }

    /**
     * @param value Relative weight of the weighted target. An integer between 0 and 100.
     */
    @JvmName("ijnoepxkchjgmynq")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The targeted port of the weighted object.
     */
    @JvmName("oseiahiusfngoakl")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Virtual node to associate with the weighted target. Must be between 1 and 255 characters in length.
     */
    @JvmName("opjtpcuyhmctfxwl")
    public suspend fun virtualNode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNode = mapped
    }

    /**
     * @param value Relative weight of the weighted target. An integer between 0 and 100.
     */
    @JvmName("csvmhaduykiyshtt")
    public suspend fun weight(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): RouteSpecTcpRouteActionWeightedTargetArgs =
        RouteSpecTcpRouteActionWeightedTargetArgs(
            port = port,
            virtualNode = virtualNode ?: throw PulumiNullFieldException("virtualNode"),
            weight = weight ?: throw PulumiNullFieldException("weight"),
        )
}
