@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteTimeoutArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property idle Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
 */
public data class RouteSpecTcpRouteTimeoutArgs(
    public val idle: Output<RouteSpecTcpRouteTimeoutIdleArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteTimeoutArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteTimeoutArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteTimeoutArgs.builder()
            .idle(idle?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RouteSpecTcpRouteTimeoutArgs].
 */
@PulumiTagMarker
public class RouteSpecTcpRouteTimeoutArgsBuilder internal constructor() {
    private var idle: Output<RouteSpecTcpRouteTimeoutIdleArgs>? = null

    /**
     * @param value Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("ehukgyonyengdqbf")
    public suspend fun idle(`value`: Output<RouteSpecTcpRouteTimeoutIdleArgs>) {
        this.idle = value
    }

    /**
     * @param value Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("xqdadcmxhujlvmar")
    public suspend fun idle(`value`: RouteSpecTcpRouteTimeoutIdleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idle = mapped
    }

    /**
     * @param argument Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("kivmbngimqaujttn")
    public suspend fun idle(argument: suspend RouteSpecTcpRouteTimeoutIdleArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecTcpRouteTimeoutIdleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.idle = mapped
    }

    internal fun build(): RouteSpecTcpRouteTimeoutArgs = RouteSpecTcpRouteTimeoutArgs(
        idle = idle,
    )
}
