@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property backendDefaults Defaults for backends.
 * @property listeners Listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one listener.
 * @property logging Inbound and outbound access logging information for the virtual gateway.
 */
public data class VirtualGatewaySpecArgs(
    public val backendDefaults: Output<VirtualGatewaySpecBackendDefaultsArgs>? = null,
    public val listeners: Output<List<VirtualGatewaySpecListenerArgs>>,
    public val logging: Output<VirtualGatewaySpecLoggingArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecArgs.builder()
            .backendDefaults(backendDefaults?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .listeners(
                listeners.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .logging(logging?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualGatewaySpecArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecArgsBuilder internal constructor() {
    private var backendDefaults: Output<VirtualGatewaySpecBackendDefaultsArgs>? = null

    private var listeners: Output<List<VirtualGatewaySpecListenerArgs>>? = null

    private var logging: Output<VirtualGatewaySpecLoggingArgs>? = null

    /**
     * @param value Defaults for backends.
     */
    @JvmName("nlakfagxnckcuika")
    public suspend fun backendDefaults(`value`: Output<VirtualGatewaySpecBackendDefaultsArgs>) {
        this.backendDefaults = value
    }

    /**
     * @param value Listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one listener.
     */
    @JvmName("dcaboqtbrbnwumvt")
    public suspend fun listeners(`value`: Output<List<VirtualGatewaySpecListenerArgs>>) {
        this.listeners = value
    }

    @JvmName("gwanraloqgbibjcw")
    public suspend fun listeners(vararg values: Output<VirtualGatewaySpecListenerArgs>) {
        this.listeners = Output.all(values.asList())
    }

    /**
     * @param values Listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one listener.
     */
    @JvmName("uljwnkynldtaupqj")
    public suspend fun listeners(values: List<Output<VirtualGatewaySpecListenerArgs>>) {
        this.listeners = Output.all(values)
    }

    /**
     * @param value Inbound and outbound access logging information for the virtual gateway.
     */
    @JvmName("awefofekedfqaorr")
    public suspend fun logging(`value`: Output<VirtualGatewaySpecLoggingArgs>) {
        this.logging = value
    }

    /**
     * @param value Defaults for backends.
     */
    @JvmName("tfgddfbrogssqune")
    public suspend fun backendDefaults(`value`: VirtualGatewaySpecBackendDefaultsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendDefaults = mapped
    }

    /**
     * @param argument Defaults for backends.
     */
    @JvmName("jpnqxpjapoogkhaq")
    public suspend fun backendDefaults(argument: suspend VirtualGatewaySpecBackendDefaultsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecBackendDefaultsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.backendDefaults = mapped
    }

    /**
     * @param value Listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one listener.
     */
    @JvmName("dfhvwqvaynwdoioh")
    public suspend fun listeners(`value`: List<VirtualGatewaySpecListenerArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.listeners = mapped
    }

    /**
     * @param argument Listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one listener.
     */
    @JvmName("ttcnxknenwismktr")
    public suspend fun listeners(argument: List<suspend VirtualGatewaySpecListenerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualGatewaySpecListenerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param argument Listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one listener.
     */
    @JvmName("kcpchtrhnylukpsp")
    public suspend fun listeners(vararg argument: suspend VirtualGatewaySpecListenerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualGatewaySpecListenerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param argument Listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one listener.
     */
    @JvmName("vtqvfkfkgfucvrcw")
    public suspend fun listeners(argument: suspend VirtualGatewaySpecListenerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualGatewaySpecListenerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param values Listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one listener.
     */
    @JvmName("rbajpqusnbcdhtnt")
    public suspend fun listeners(vararg values: VirtualGatewaySpecListenerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.listeners = mapped
    }

    /**
     * @param value Inbound and outbound access logging information for the virtual gateway.
     */
    @JvmName("yhmlwiuflmwilyse")
    public suspend fun logging(`value`: VirtualGatewaySpecLoggingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logging = mapped
    }

    /**
     * @param argument Inbound and outbound access logging information for the virtual gateway.
     */
    @JvmName("yemmkuojsmrujvjn")
    public suspend fun logging(argument: suspend VirtualGatewaySpecLoggingArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecLoggingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logging = mapped
    }

    internal fun build(): VirtualGatewaySpecArgs = VirtualGatewaySpecArgs(
        backendDefaults = backendDefaults,
        listeners = listeners ?: throw PulumiNullFieldException("listeners"),
        logging = logging,
    )
}
