@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property tls Transport Layer Security (TLS) client policy.
 */
public data class VirtualGatewaySpecBackendDefaultsClientPolicyArgs(
    public val tls: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyArgs.builder()
            .tls(tls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualGatewaySpecBackendDefaultsClientPolicyArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecBackendDefaultsClientPolicyArgsBuilder internal constructor() {
    private var tls: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsArgs>? = null

    /**
     * @param value Transport Layer Security (TLS) client policy.
     */
    @JvmName("nvsebedyxcnchigi")
    public suspend fun tls(`value`: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsArgs>) {
        this.tls = value
    }

    /**
     * @param value Transport Layer Security (TLS) client policy.
     */
    @JvmName("xaguksrgxvhhbphp")
    public suspend fun tls(`value`: VirtualGatewaySpecBackendDefaultsClientPolicyTlsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tls = mapped
    }

    /**
     * @param argument Transport Layer Security (TLS) client policy.
     */
    @JvmName("rqnxlwkglfssljsw")
    public suspend fun tls(argument: suspend VirtualGatewaySpecBackendDefaultsClientPolicyTlsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecBackendDefaultsClientPolicyTlsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tls = mapped
    }

    internal fun build(): VirtualGatewaySpecBackendDefaultsClientPolicyArgs =
        VirtualGatewaySpecBackendDefaultsClientPolicyArgs(
            tls = tls,
        )
}
