@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property certificateAuthorityArns One or more ACM ARNs.
 */
public data class VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgs(
    public val certificateAuthorityArns: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgs.builder()
            .certificateAuthorityArns(
                certificateAuthorityArns.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgsBuilder internal constructor() {
    private var certificateAuthorityArns: Output<List<String>>? = null

    /**
     * @param value One or more ACM ARNs.
     */
    @JvmName("buphkmvxhfdeefht")
    public suspend fun certificateAuthorityArns(`value`: Output<List<String>>) {
        this.certificateAuthorityArns = value
    }

    @JvmName("odlcrpfnixcmjosr")
    public suspend fun certificateAuthorityArns(vararg values: Output<String>) {
        this.certificateAuthorityArns = Output.all(values.asList())
    }

    /**
     * @param values One or more ACM ARNs.
     */
    @JvmName("spnjiniytvpbokyb")
    public suspend fun certificateAuthorityArns(values: List<Output<String>>) {
        this.certificateAuthorityArns = Output.all(values)
    }

    /**
     * @param value One or more ACM ARNs.
     */
    @JvmName("mcbbvfomtdavtcxr")
    public suspend fun certificateAuthorityArns(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateAuthorityArns = mapped
    }

    /**
     * @param values One or more ACM ARNs.
     */
    @JvmName("bugidqwuqiigukhc")
    public suspend fun certificateAuthorityArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateAuthorityArns = mapped
    }

    internal fun build(): VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgs =
        VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgs(
            certificateAuthorityArns = certificateAuthorityArns ?: throw
                PulumiNullFieldException("certificateAuthorityArns"),
        )
}
