@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property acm TLS validation context trust for an AWS Certificate Manager (ACM) certificate.
 * @property file TLS validation context trust for a local file certificate.
 * @property sds TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
 */
public data class VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustArgs(
    public val acm: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgs>? =
        null,
    public val `file`: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustFileArgs>? = null,
    public val sds: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustSdsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustArgs.builder()
            .acm(acm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .`file`(`file`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sds(sds?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustArgsBuilder internal constructor() {
    private var acm: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgs>? =
        null

    private var `file`:
        Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustFileArgs>? = null

    private var sds: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustSdsArgs>? =
        null

    /**
     * @param value TLS validation context trust for an AWS Certificate Manager (ACM) certificate.
     */
    @JvmName("tijuwljosnxpjsea")
    public suspend fun acm(`value`: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgs>) {
        this.acm = value
    }

    /**
     * @param value TLS validation context trust for a local file certificate.
     */
    @JvmName("abrtunnpdsskuukc")
    public suspend fun `file`(`value`: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustFileArgs>) {
        this.`file` = value
    }

    /**
     * @param value TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("dmwkemuwdkyfeymx")
    public suspend fun sds(`value`: Output<VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustSdsArgs>) {
        this.sds = value
    }

    /**
     * @param value TLS validation context trust for an AWS Certificate Manager (ACM) certificate.
     */
    @JvmName("kcudbwjjmwrrkxwu")
    public suspend fun acm(`value`: VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acm = mapped
    }

    /**
     * @param argument TLS validation context trust for an AWS Certificate Manager (ACM) certificate.
     */
    @JvmName("hmfgnltbjxubghfc")
    public suspend fun acm(argument: suspend VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.acm = mapped
    }

    /**
     * @param value TLS validation context trust for a local file certificate.
     */
    @JvmName("rcytyblkbctspaww")
    public suspend fun `file`(`value`: VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustFileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param argument TLS validation context trust for a local file certificate.
     */
    @JvmName("ylsnkvvfmmcotvae")
    public suspend fun `file`(argument: suspend VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustFileArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustFileArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.`file` = mapped
    }

    /**
     * @param value TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("pomecijequcwsfuw")
    public suspend fun sds(`value`: VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustSdsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sds = mapped
    }

    /**
     * @param argument TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("hshhqrjtmwhqusap")
    public suspend fun sds(argument: suspend VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustSdsArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustSdsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sds = mapped
    }

    internal fun build(): VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustArgs =
        VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustArgs(
            acm = acm,
            `file` = `file`,
            sds = sds,
        )
}
